<div ng-controller="viewcoachingcenterCtrl">
    <div class="row multi_line white no-border color-dark-gray container" style="margin: 0 !important;">
        <div class="titles border-bottom row gutter_vertical">
            <h3 class="uppercase gutter_vertical left">Find Coaching Institutes</h3>
        </div>
        <div class="border-bottom gutter_vertical">
            <div class="relative gutter_vertical clearfix">
                <div class="grid_3 pull small_gutter_r">
                    <input type="text" ng-model="testinput" test-auto-complete class="input small_gutter_r grid_3" placeholder="Type and choose test">
                </div>
                <div class="grid_4 pull small_gutter_r">
                    <input type="text" ng-model="locationinput" location-auto-complete class="input small_gutter_r grid_4" placeholder="Type and choose location">
                </div>
                <div class="left small-right">
                    <button class="button-blue tny" ng-click="searchCenters();">Search</button>
                </div>
            </div>
        </div>
        <loading></loading>
        <div class="row multi_line lightyellow border-bottom gutter_vertical" ng-if="noResults && !defaultMessage">
            <div class="row multi_line small-gutter center">
                <span class="gutter20">There are no institutes found.</span>
            </div>
        </div>
        <div class="row multi_line lightyellow border-bottom gutter_vertical" ng-if="defaultMessage">
            <div class="row multi_line small-gutter center">
                <span class="gutter20">Choose Test and Location to find coaching institutes.</span>
            </div>
        </div>
        <div ng-if="coachingCenters.length">
            <div class="row multi_line small-gutter gutter_vertical gray">
                <div class="grid_5 pull">Institute Name</div>
                <div class="left">Establishment Year</div>
                <div class="left small-right">Distance (approx)</div>
            </div>

            <div class="row multi_line gutter_vertical border-top relative visible clearfix"
                 ng-repeat="coachingCenter in coachingCenters">
                <div class="heading grid_5 pull">
                    <div class="gutter_vertical small_gutter_l">
                        <h4 class=""><a href="{{coachingCenter.link}}" target="_blank">{{coachingCenter.name}}</a></h4>
                        {{coachingCenter.address}}
                        <small style="padding: 5px;" ng-show="coachingCenter.verified == 'Y'" class="row dark-green small_gutter_l uppercase color-white"><i class="fa fa-thumbs-up fa-lg small_gutter_r "></i>Verified</small>
                    </div>
                </div>
                <div class="grid_2 pull left gutter-left-35">{{coachingCenter.establishment_year}}</div>
                <div class="grid_1 pull"> {{coachingCenter.distance}} km </div>
                <div title="{{!coachingCenter.shortlisted ? 'Add to' : 'Remove from'}} Shortlist" class="tag-image"
                     ng-class="coachingCenter.shortlisted ? 'addedtag' : 'addtag'"
                     ng-click="updateCenterShortlist(coachingCenter, !coachingCenter.shortlisted ? 'ADD':'REMOVE')">&nbsp;
                </div>

            </div>
        </div>
    </div>
</div>