<?php
class CareerPlanFormModel extends CFormModel {

    public $hidden_temp;
    public $country_of_interest = array();
    public $major_of_interest = array();
    public $country_scholarship_texts = array(
        '224' => "Average tuition fees in US can range from $15,000 - $50,000 per year. Will you go to US even if you don't get scholarship?",
        '100' => "In India, fee varies from low to very high for different courses. Will you study in India even if you don't get scholarship?",
        '223' => "Average tuition fees in UK is around $14,000 per year. Will you go to UK even if you don't get scholarship?",
        '190' => "Average tuition fees is around $20,000 per year. Will you go to Singapore even if you don't get scholarship?",
        '12'  => "Average tuition fees is around $30,000 per year. Will you go to Australia even if you don't get scholarship?",
        '154' => "Average tuition fees is around $30,000 per year. Will you go to New Zealand even if you don't get scholarship?"
    );

    public function rules() {

        return array(
            array('country_of_interest','ValidateCountryInfo'),
            array('major_of_interest','ValidateDepartmentInfo'),
            array('country_of_interest, major_of_interest, hidden_temp', 'safe'),
        );
    }

    public function _ce($error){
        return '<div class="holder"><p>'.$error.'</p></div>';
    }
    public function addError($attribute,$error) {
        parent::addError($attribute, $this->_ce($error));
    }

    public function attributeLabels(){

        return array(
            'country_of_interest' => 'Country',
            'major_of_interest' => 'Major',
        );
    }

    public function getCountriesList(){

        $countriesList = TblCountryMaster::getUnivarietyCountries();
        $countries = CHtml::listData($countriesList,'country_id', 'country_name');

        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countries);
        $countries['Others'] = $uniqueCountryList;

        return $countries;
    }

    public function getMajorsList(){

        return LookupDepartment::getMainDepartmentList();
    }

    public function ValidateCountryInfo($attribute){

        if($this->country_of_interest){
            $countryIDs = array();
            foreach($this->country_of_interest as $key => $country_of_interest){
                $countryID = $country_of_interest['country_id'];
                if(!$countryID) continue;
                if(in_array($countryID, $countryIDs)){
                    $this->addError($attribute.'_'.$key.'_country_id', $this->getAttributeLabel($attribute)." is already chosen."); }
                else{
                    $countryIDs[] = $countryID;
                }
            }

            if(count($countryIDs) == 0){
                reset($this->country_of_interest);
                $key = key($this->country_of_interest);
                $this->addError($attribute.'_'.$key.'_country_id', "Please choose at least one country.");
            }
        }
    }

    public function ValidateDepartmentInfo($attribute){

        if($this->major_of_interest){
            $deptCombs = array();
            foreach($this->major_of_interest as $key => $major_of_interest){
                $deptID = $major_of_interest['major_id'];
                if(!$deptID) continue;

                $deptComb = $major_of_interest['major_id'].'-'.$major_of_interest['sub_dept_id'];
                if(in_array($deptComb, $deptCombs)){
                    $this->addError($attribute.'_'.$key.'_major_id', "This ".$this->getAttributeLabel($attribute)." combination already chosen.");
                }
                else{
                    $deptCombs[$key] = $deptComb;
                }
            }

            $emptySubDeptCombs = array_filter($deptCombs, function($v){
                list($majorID, $subDeptID) = explode('-', $v);
                return empty($subDeptID);
            });
            if(count($emptySubDeptCombs)){
                foreach($emptySubDeptCombs as $k => $comb){
                    list($majorID, $subDeptID) = explode('-', $comb);
                    $isRepeated = array_filter($deptCombs, function($v) use($majorID){
                        list($tmajorID, $tsubDeptID) = explode('-', $v);
                        return $tmajorID == $majorID && !empty($tsubDeptID);
                    });
                    if(count($isRepeated)){
                        $this->addError($attribute.'_'.$k.'_sub_dept_id', "Please choose a different department");
                    }
                }
            }

            if(count($deptCombs) == 0){
                reset($this->major_of_interest);
                $key = key($this->major_of_interest);
                $this->addError($attribute.'_'.$key.'_major_id', "Please choose at least one major.");
            }
        }
    }

    public function saveCountryPreferencesInfo($userID){

        $countryPreferences = StudentPreferredCountry::model()->findAll("user_ref_id = '".$userID."'");
        foreach($countryPreferences as $_StudentPreferredCountry){
            $_StudentPreferredCountry->delete();
        }
        $i=1;
        foreach($this->country_of_interest as $key => $country_of_interest){
            $countryID = $country_of_interest['country_id'];
            $no_scholarship = $country_of_interest['no_scholarship'];
            $location = $country_of_interest['location'];
            if(!$countryID) continue;

            $countryPref = new StudentPreferredCountry();
            $countryPref->setAttributes(array(
                'user_ref_id' =>$userID,
                'country_ref_id'=>$countryID,
                'preference_order'=> $i,
                'no_scholarship' => $no_scholarship ? 1 : (($no_scholarship =='0') ? '0' : new CDbExpression('NULL')) ,
                'added_on' => date('Y-m-d H:i:s')
            ), false);
            $countryPref->save(false);
            $i++;
            if($location){
                $locations = explode(',',$location);
                foreach ($locations as $k => $loc){

                    $locationPref = new StudentPreferredLocation();
                    $locationPref->setAttributes(array(
                        'preferred_country_ref_id' => $countryPref->preferred_country_id,
                        'added_on' => date('Y-m-d H:i:s'),
                    ), false);

                    $subString = substr($loc,0,1);
                    $clrLoc = substr($loc,1);
                    if($subString == 'c') {
                        $locationPref->city_ref_id = $clrLoc;
                    } elseif($subString == 's') {
                        $locationPref->state_ref_id = $clrLoc;
                    } elseif($subString == 'r') {
                        $locationPref->region_ref_id = $clrLoc;
                    }
                    $locationPref->save(false);
                }
            }
        }
    }

    public function saveMajorPreferencesInfo($userID){

        $majorPreferences = StudentPreferredDepartment::model()->findAll("user_ref_id = '".$userID."'");
        foreach($majorPreferences as $_StudentPreferredDepartment)
            $_StudentPreferredDepartment->delete();

        $i=1;
        foreach($this->major_of_interest as $key => $major_of_interest){
            $deptID = $major_of_interest['major_id'];
            $subDeptID = $major_of_interest['sub_dept_id'];
            if(!$deptID) continue;

            $majorPref = new StudentPreferredDepartment();
            $majorPref->setAttributes(array(
                'user_ref_id'=> $userID,
                'main_dept_ref_id'=> $deptID,
                'sub_dept_ref_id'=> $subDeptID ? $subDeptID : new CDbExpression('NULL'),
                'preference_order'=> $i,
                'added_on' => date('Y-m-d H:i:s'),
            ), false);
            $majorPref->save(false);
            $i++;
        }
    }
}

?>