<?php

/**
 * Model class for UserMilestone
 * This class handles user milestones, like when it is completed, invalidate scenarios etc.,
 *
 * @author Shiva <shiva.dharana@univariety.com>
 * @version 1.0
 * @package sms.models
 */

Yii::import('application.modules.sms.models.base.BaseUserMilestoneSuggestion');

class UserMilestoneSuggestion extends BaseUserMilestoneSuggestion
{
    public static function model($className=__CLASS__){
        return parent::model($className);
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules(){
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
        array('user_ref_id, milestone_id, added_by, suggestion', 'required'),
        array('milestone_id', 'numerical', 'integerOnly'=>true),
        array('user_ref_id, added_by', 'length', 'max'=>10),
        array('suggestion, added_on', 'safe'),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('user_milestone_suggestion_id, user_ref_id, milestone_id, suggestion, added_by, added_on', 'safe', 'on'=>'search'),
        );
    }
    
    protected function beforeSave(){
        if(parent::beforeSave()){
            if($this->isNewRecord){
                $this->added_on = date('Y-m-d H:i:s');
            }
            return true;
        }
        return false;
    }
}