<section id="section1" class="section">
	<div class="div-inner-gutter-space">
		<div class="row gutter_vertical">
			<h3 class="left">Recommendation Summary</h3>
            <a href="<?php echo Yii::app()->createUrl('login/logout');?>" class="right" style="margin-left: 20px;">Logout</a>
            <a href="<?php echo Yii::app()->createUrl('setPassword');?>" class="right">Change password</a>
		</div>
        <?php
        Yii::app()->clientScript->registerScript('search', "
        $('#searchByName').keyup(function() {
              $.fn.yiiListView.update('rec-summary-list-view', {  data: $('.filterElement').serialize()  });
        });
        ");
        ?>
        <?php
        $form = $this->beginWidget('CActiveForm');
        ?>

        <div class="row multi_line no-gutter gutter_vertical">
            <h4 class="left">Welcome,
            <?php
            $loginModel = LoginMaster::model()->findByPk(Yii::app()->user->id);
            if($loginModel->user_type_ref_id == 9) { // 9- for Teacher
                $details = LorTeachersInfo::model()->findByPk(Yii::app()->user->sub_id);
                echo $details->first_name.' ('.$details->teacherSubjectRef->subject_name.')';
            } else if($loginModel->user_type_ref_id == 2){ // Counsellor
                $details = TblSiDi::model()->findByPk(Yii::app()->user->sub_id);
                echo $details->inst_name;
            } else {
                $details = LorOthersInfo::model()->findByPk(Yii::app()->user->sub_id);
                $first_name = $details->first_name;
                echo $details->first_name.' ('.$details->relationRef->relation.')';
            }
            ?>
            </h4>
            <?php echo $form->textField($model,'full_name', array('class' =>'grid_4 right search tny filterElement', 'id' =>'searchByName', 'placeholder' => 'Search by student name, email')); ?>
        </div>
        <?php $this->endWidget(); ?>

		<div class="clearfix gutter_vertical">
            <?php
            $this->widget('zii.widgets.CListView', array(
                'dataProvider'=>$model->getRecommendationSummary(),
                'itemView'=>'_student_summary_list_view',
                'viewData'=>array('model'=>$model),
                'id'=>'rec-summary-list-view',
                'ajaxUrl' => Yii::app()->createUrl('milestoneprogress/lor/recommendationSummary'),
                'summaryText'=>'',
                'template'=>"
                        <table class='grid_view'>
                        <thead>
                        <tr class='gray-bg'>
                            <th>Student name</th>
                            <th>College</th>
                            <th>Invited On </th>
                            <th>Type </th>
                            <th>Status</th>
                        </tr>
                        </thead>
				        {items}
				    </table>
				   \n{pager}",
                'pager'=>array('header'=>'',),
                'emptyText' => "<tr><td class='center' colspan='7'>No results found.</td></tr>",
            ));
            ?>

		</div>
	</div>
</section>
<script>
    $('body').on('change', '.teacherInviteStatus', function(){
        var self = $(this)
        if(confirm('Are sure, you want to change status?')) {
            $.post(ibase_url + 'milestoneprogress/lor/lorChangeStatus', {inviteid: self.data('inviteid'),'status': self.val()}, function () {
                $.notification({class:'success_notify', notification:'notification_geniric',replaceKeys:{MESSAGE:'Status changed  Successfully'}});
            });
        }
    });
</script>