<style>
/*-Right side Sticky Flag CSS*/
     .sticky-right{
        position:fixed; top:25%; right:-1%;z-index:99999;display:block;
        -webkit-box-shadow: -12px 14px 5px -8px rgba(179,170,179,1);
        -moz-box-shadow: -12px 14px 5px -8px rgba(179,170,179,1);
        box-shadow: -12px 14px 5px -8px rgba(179,170,179,1);
     }
     .sticky-right-rp{
         padding-right: 10px;
     }
     /* Base styles for the tooltip's content area */
     .wrapper .tooltip {
        background: #020202;
        bottom: 100%;
        color: #fff;
        display:inline-table;
        left: -263px;
        /* margin-bottom: 47px; */
        opacity: 0;
        padding: 8px 5px 15px 5px;
        pointer-events: none;
        position: absolute;
        width: 100%;
        top: -10px;
        line-height: 1.2em;
        border-radius: 4px;
     }
     .wrapper:hover .tooltip {
        opacity: 1;
        pointer-events: auto;
        -webkit-transform: translateY(0px);
        -moz-transform: translateY(0px);
        -ms-transform: translateY(0px);
        -o-transform: translateY(0px);
        transform: translateY(0px);
    }
     .wrapper .tooltip:before {
        border-width: 14px;
        border-left-color: #020202;
        top: 10px;
     }
     .wrapper .tooltip:before, .wrapper .tooltip:after {
        border: solid transparent;
        content: ' ';
        height: 0;
        left: 100%;
        position: absolute;
        width: 0;
     }
     .wrapper .tooltip:after {
        border-width: 9px;
        border-left-color: #020202;
        top: 15px;
     }
</style>

<?php
$studentID = $uid;
$datePickerAssets = Yii::app()->assetManager->publish(Yii::getPathOfAlias('ext.CJuiDateTimePicker.assets'));
Yii::app()->clientScript->registerScriptFile($datePickerAssets."/jquery-ui-timepicker-addon.js", CClientScript::POS_END);
Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/token-input-facebook.css");
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.tokeninput.js");

$interestingProducts = InterestingProducts::model()->findAll();
$userInterestedProducts = CHtml::listData(
    StudentInterestedProducts::model()->findAll('student_ref_id= :userid', [':userid'=>$studentID]),
    'interesting_product_ref_id', 'interesting_product_ref_id'
);
$levelUpHelp = StudentCounsellingRequest::model()->find('student_ref_id= :userid', [':userid'=>$studentID]);
$subjectHelp = StudentSubjectHelp::model()->with('subjectRef')->findAll('student_ref_id= :userid', [':userid'=>$studentID]);
$productComments = StudentProductComment::model()->findAll('student_ref_id= :userid', [':userid'=>$studentID]);
?>
<div id="sticky-right" class="sticky-right">
    <div class="row multi_line small-gutter white visible relative light-gray">
        <h4 class="uppercase border-bottom gutter_vertical">MY PRODUCTS</h4>
        <div class="sticky-right-rp">
            <?php
            foreach($interestingProducts as $product){
                ?>
                <div>
                    <input type="checkbox" class="interestingProduct"
                           data-info='<?php echo json_encode(['id'=>$product->product_id, 'name'=>$product->product_name]);?>'
                        <?php in_array($product->product_id, $userInterestedProducts) AND print "checked"; ?>>
                    <?php echo $product->product_name; ?>
                </div>
                <?php
            }
            ?>
            <div class="wrapper visible relative border-top small_gutter_t">
                <input type="checkbox" class="levelUpHelp" <?php $levelUpHelp AND print 'checked'; ?>> L2 Counselling
                <a href="javascript:void(0);" class="levelUpHelpIcon" title="Edit"
                   style="<?php !$levelUpHelp AND print 'display:none'; ?>"><i class="fa fa-pencil color-blue"></i></a>
                <div class="tooltip levelUpHelpToolTip" style="width:250px;<?php !$levelUpHelp AND print 'display:none'; ?>">
                    <div class="holder basefont">
                        <?php if($levelUpHelp){ ?>
                            <p>
                                <?php echo sprintf('Date: %s | Time: %s',
                                    DateTime::createFromFormat('Y-m-d', $levelUpHelp->schedule_date)->format('d.m.Y'),
                                    DateTime::createFromFormat('H:i:s', $levelUpHelp->schedule_time)->format('g:i a')
                                ); ?>
                            </p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="gutter_vertical wrapper visible relative">
                <input type="checkbox" class="subjectHelp" <?php $subjectHelp AND print 'checked'; ?>> Subject Help
                <a href="javascript:void(0);" class="subjectHelpIcon" title="Edit"
                   style="<?php !$subjectHelp AND print 'display:none'; ?>"><i class="fa fa-pencil color-blue"></i></a>

                <div class="tooltip subjectHelpToolTip" style="width:250px;<?php !$subjectHelp AND print 'display:none'; ?>">
                    <div class="holder basefont">
                        <?php if($subjectHelp){
                                $subjects=[];
                                foreach($subjectHelp as $subject){
                                    $subjects[] = $subject->subjectRef->subject_name;
                                }
                            ?>
                            <p><?php echo implode(', ', $subjects); ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="border-top small_gutter_t wrapper visible relative">
            <a href="javascript:void(0);" class="viewComments" ><i class="fa color-blue fa-weixin"></i> Comments</a>
            <span class="productCommentsIcon" style="position:relative;padding:0 5px; vertical-align: middle;  background-color:#e20509;color:#fff;bottom:8px;left:5px;<?php !$productComments AND print 'display:none'; ?>">
                <small id="commentsCnt"><?php echo count($productComments); ?></small>
            </span>
        </div>
    </div>
</div>
<script>
    $(function(){

        var showCounsellingScheduleForm = function(){
            $.fancybox.open({
                href: ibase_url + 'milestoneprogress/default/Level2Counselling?uid='+milestoneStudentID,
                type: 'ajax', width: 800, autoHeight: 500,
                helpers: {overlay: {closeClick: false}},
                keys: {close: null}
            });
        };

        var showSubjectHelpForm = function(){
            $.fancybox.open({
                href: ibase_url + 'milestoneprogress/default/SubjectHelp?uid='+milestoneStudentID,
                type: 'ajax', width: 800, autoHeight: 500,
                helpers: {overlay: {closeClick: false}},
                keys: {close: null}
            });
        };

        $('body').on('click', '.interestingProduct', function(){
            var productInfo = $(this).data('info'), isChecked = this.checked;
            $.post(ibase_url + "milestoneprogress/default/updateinterestingProduct",
                {id:productInfo.id, status:isChecked ? 1:0, uid:milestoneStudentID}, function(){
                $.notification({
                    class: "success_notify",
                    notification: "notification_geniric",
                    replaceKeys: {MESSAGE: productInfo.name + " has been "+ (isChecked ? "assigned" : "removed") +" successfully."}
                });
            })
        });

        $('body').on('click', '.levelUpHelp', function(){
            if(this.checked) {
                showCounsellingScheduleForm();
                return false;
            }else{
                if(confirm('Are you sure, you want to remove?')) {
                    $.post(ibase_url + "milestoneprogress/default/removel2counselling?uid="+milestoneStudentID, function(){
                        $(".levelUpHelp").prop("checked", false);
                        $(".levelUpHelpIcon, .levelUpHelpToolTip").hide();
                        $.notification({
                            class: "success_notify",
                            notification: "notification_geniric",
                            replaceKeys: {MESSAGE: "Level 2 Counselling has been removed successfully."}
                        });

                    });
                }else
                    return false;
            }
        });

        $('body').on('click', '.levelUpHelpIcon', showCounsellingScheduleForm);

        $('body').on('click', '.viewComments', function(){
            $.fancybox.open({
                href: ibase_url + 'milestoneprogress/default/showProductComments?uid='+milestoneStudentID,
                type: 'ajax', width: 800, autoHeight: 500,
                helpers: {overlay: {closeClick: false}},
                keys: {close: null}
            });
        });

        $('body').on('click', '.subjectHelpIcon', showSubjectHelpForm);

        $('body').on('click', '.subjectHelp', function(){
            if(this.checked) {
                showSubjectHelpForm();
                return false;
            }else{
                if(confirm('Are you sure, you want to remove?')) {
                    $.post(ibase_url + "milestoneprogress/default/removesubjects?uid="+milestoneStudentID, function(){
                        $(".subjectHelp").prop("checked", false);
                        $(".subjectHelpIcon, .subjectHelpToolTip").hide();
                        $.notification({
                            class: "success_notify",
                            notification: "notification_geniric",
                            replaceKeys: {MESSAGE: "Subject help has been removed successfully."}
                        });

                    });
                }else
                    return false;
            }
        });

        $("body").on('focus', 'input, select',function(){
            $(this).next('div.errorMessage').hide('slow');
        });
    });
</script>