<?php
$userID = $uid;
$user = TblUserMaster::model()->findByPk($userID);
$milestoneData = UserMilestoneTracking::model()->find(
    sprintf("user_ref_id = %d AND milestone_ref_id=5", $userID));
$shortlistedColleges = StudentShortlistUniversity::model()->with(array('uniRef', 'uniRef.countryRef'))->findAll(array(
    'condition'=>"t.user_ref_id=:userID AND t.shortlist_status != 'Reject' AND uniRef.is_active='Y'",
    'params'=>array(':userID'=>$userID),
    'order'=>'t.added_on DESC'
));
$statusOptions = array('MightApply'=>'Might Apply', 'WillApply'=>'Will Apply', 'Applied'=>'Applied');
?>
<div>
    <div class="row multi_line small-gutter white gutter_vertical">
        <div class="clearfix gutter_vertical">
            <div class="gutter_vertical left grid_6 small-right">
                <h4 class="left grid_3 small-right"><span class="link-button button-green small_gutter_r">5</span> Colleges Shortlisted</h4>
                <?php if($milestoneData && $milestoneData->completion_date){ ?>
                    <span class="color-green"><strong>
                            Completed ( <?php echo (new DateTime($milestoneData->completion_date))->format('jS M Y'); ?> )
                        </strong></span>
                <?php }else{ ?>
                    <span class="color-gray"><strong>
                            Pending ( <?php echo $milestoneData->deadline_date ?
                                (new DateTime($milestoneData->deadline_date))->format('jS M Y') : 'N/A'; ?> )
                        </strong></span>
                <?php } ?>
            </div>
            <div class="left actionable">
                <div class="left relative small-right sliderMP" style="overflow: hidden;">
                    <div class="left small_gutter_t small-right">Tools: </div>
                    <div class="row multi_line no-clear light-gray bordered pull slides_container" style="border-radius: 50px; padding: 4px 28px !important; width: 360px;">
                        <div class="small">
                            <a target="_blank" href="/app/collegeSearch">
                                <img src="/app/themes/new_grid_theme/views/layouts/images/college-icon.png" > College Search</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix right gutter_vertical actionable">
            <input type="text" class="search tny2 small_gutter_r grid_4 college_search" placeholder="Find and Shortlist Colleges" style="border-radius: 30px; padding: 4px 21px !important; background-position: 103% -0%">
            <button type="button" class="button-blue link-button shortlistCollege">Add</button>
        </div>
        <div class="gutter-left-35">
            <div class="row multi_line no-gutter small gutter_vertical">
                <div class="grid_5 pull">College</div>
                <div class="grid_2 pull">Country</div>
                <div class="grid_2 pull">Status</div>
                <div class="left small-right">Recommendation Required</div>
            </div>
            <?php
            if($shortlistedColleges){
                foreach($shortlistedColleges as $shortlistedCollege){
                    $uniID = $shortlistedCollege->uni_ref_id;
                    $uniName = $shortlistedCollege->uniRef->uni_name;
                    $countryName = $shortlistedCollege->uniRef->countryRef->country_name;
                    $uniLink    = $uniName;
                    //$uniLink    = $shortlistedCollege->uniRef->url_primary_key ?
                        //CHtml::link($uniName, Yii::app()->getbaseUrl(true).UniversityHelper::getUniversityUrl($uniID), array('target'=>'_blank')) : $uniName;
                    ?>
                    <div class="row multi_line border-top collegeRow" style="padding: 7px 0px !important" data-college-id="<?php echo $uniID; ?>" data-college-name="<?php echo $uniName; ?>">
                        <div class="grid_5 pull"><?php echo $uniLink; ?></div>
                        <div class="grid_2 pull">
                            <?php echo $countryName ?: '-'; ?>
                        </div>
                        <div class="grid_2 pull">
                            <?php
                            $selected = str_replace(' ', '', $shortlistedCollege->shortlist_status);
                            echo CHtml::dropDownList('shortlist_status', $selected, $statusOptions,
                                array('class'=>'left small-right shortlist_status'));
                            ?>
                        </div>
                        <?php if(in_array($user->membership_ref_id, array(2,4) )) { ?>
                        <div class="grid_2 pull center">
                            <?php if($shortlistedCollege->uniRef->lor_required == 'Y' && 0){
                                $hasSentInvites = LorInviteInfo::model()->exists(sprintf('uni_ref_id=%s AND user_ref_id=%s', $uniID, $userID));
                                ?>
                                <a href="#" class="link-button button-green viewInvites"><?php echo $hasSentInvites ? 'View Invites' : 'Yes & Invite'; ?></a>
                            <?php }else{ ?>
                                <span class="color-gray">Not Required</span>
                            <?php } ?>
                        </div>
                        <?php } else {  ?>
                            <span class="color-gray"> -- </span>
                        <?php } ?>
                        <div class="right actionable">
                            <a href="#" class="deleteCollege" title="Delete"><i class="fa fa-times"></i></a>
                        </div>
                        <?php if($shortlistedCollege->uniRef->lor_required == 'Y' && 0){ ?>
                        <div class="row lorInfo multi_line small-gutter clearfix lightyellow" style="<?php echo isset($_GET['bypass']) ? '':'display: none;'; ?> margin-top: 45px;">
                            <div class="row multi_line small-gutter small ">
                                <div class="grid_3 pull">Type</div>
                                <div class="grid_2 pull">Required</div>
                                <div class="grid_2 pull">Allowed</div>
                            </div>

                            <?php
                            $lorMatrix = TblLorInviteMatrix::model()->findAll(array("condition" => "uni_ref_id = '".$uniID."'","order" => "lor_type_ref_id"));
                            if($lorMatrix){
                                foreach($lorMatrix as $matrix){ ?>
                                    <div class="row multi_line small-gutter border-top">
                                        <div class="grid_3 pull" style="font-weight: bold;"><?php echo $matrix->lorTypeRef->lor_name;?></div>
                                        <div class="grid_2 pull"><?php echo $matrix->required;?></div>
                                        <div class="grid_2 pull"><?php echo $matrix->allowed;?></div>
                                        <div class="">
                                            <?php
                                            $sentInvites = LorInviteInfo::model()->findAll(sprintf('uni_ref_id=%d AND user_ref_id=%d AND lor_type_ref_id=%d', $uniID, $userID, $matrix->lorTypeRef->lor_type_id));
                                            if(in_array($matrix->lorTypeRef->lor_type_id, array(2,4)) || count($sentInvites)<1) { ?>
                                            <a href="javascript:void(0);" class="link-button button-blue inviteLink actionable"
                                               data-invite-type="<?php echo $matrix->lorTypeRef->lor_type_id;?>">Invite</a>
                                            <?php } else { ?>
                                            <span class="color-gray">Invited</span>
                                        <?php } ?>
                                        </div>
                                        <?php
                                        if($sentInvites)
                                        {
                                            foreach($sentInvites as $invite) { ?>
                                            <div class="row multi_line no-gutter clearfix" style="margin-top: 2px;">
                                                <div class="row multi_line small-gutter white no-border small" style="padding: 2px 7px!important; ">
                                                    <?php if($matrix->lorTypeRef->lor_type_id == '2') { ?>
                                                    <div class="grid_3 pull"><?php echo $invite->teacherRef->first_name.' '.$invite->teacherRef->last_name?></div>
                                                    <div class="grid_4 pull"><?php echo $invite->teacherRef->email;?></div>
                                                    <div class="grid_2 pull"><?php echo $invite->teacherRef->teacherSubjectRef->subject_name;?></div>
                                                    <?php } if($matrix->lorTypeRef->lor_type_id == '4') { ?>
                                                    <div class="grid_3 pull"><?php echo $invite->otherRef->first_name.' '.$invite->otherRef->last_name?></div>
                                                    <div class="grid_4 pull"><?php echo $invite->otherRef->email;?></div>
                                                    <div class="grid_2 pull"><?php echo $invite->otherRef->relationRef->relation;?></div>
                                                <?php } if(in_array($matrix->lorTypeRef->lor_type_id, array(1,3)))  { ?>
                                            <div class="grid_3 pull"><?php echo $invite->counsellorRef->inst_name?></div>
                                            <div class="grid_4 pull"><?php echo $invite->counsellorRef->inst_email;?></div>
                                            <div class="grid_2 pull">N/A</div>
                                            <?php } ?>
                                                    <div class="right color-gray"><?php echo $invite->invite_status?:'Pending';?></div>
                                                </div>
                                            </div>
                                        <?php }
                                        } ?>
                                    </div>
                                    <?php

                                }
                            }
                            ?>

                        </div>
                        <?php } ?>
                    </div>
                    <?php
                }
            }else{
                echo '<div class="center row gutter_vertical dark-pink gutter-left-35">No Colleges found.</div>';
            }
            ?>
        </div>
        <div class="center actionable">
            <button type="button" onclick="goHash('admissionSection', this.form)" class="button-default tny small_gutter_r">Skip</button>
        </div>
    </div>
</div>