<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'shareDiscussionData',
    'enableAjaxValidation' => true,
    'enableClientValidation' => false,
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'validateOnType' => false,
        'afterValidate' => 'js:function(form, data, hasError){
            if(!$.isEmptyObject(data)){
                for(var i in data) {
                    var id = i, message = data[i][0];
                   $("#"+i+"_em_").html(message).show();
                }
                $("div.container").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                return false;
            }else {
                postData(form);
            }
        }',
    )
));
?>
<div class="row multi_line white color-dark-gray small-gutter container" style="margin-top: 0px; width: 600px">
    <h4 class="center uppercase gutter_vertical">Send Email</h4>
    <div class="color-gray">Select and send</div>
    <div class="row multi_line no-gutter gutter_vertical">
        <?php
        $toList = array();
        $user = TblUserMaster::model()->findByPk($uid);
        $parentEmail = StudentAlternateEmail::getAllParentEmails($user->login_ref_id);
        $instInfo = TblSiStudents::model()->findByAttributes(array('user_ref_id'=>$user->user_id));
        $siInfo = TblSiDi::model()->findByPk($instInfo->inst_ref_id);
        if($parentEmail[0]['email_id']){
            $toList['Parent'] = $parentEmail[0]['email_id'];
        }
        if($siInfo->inst_email){
            $toList['Counsellor'] = $siInfo->inst_email;
        }
        if($siInfo->principal_email){
            $toList['Principal'] = $siInfo->principal_email;
        }
        if($user->loginRef->username){
            $toList['Student'] = $user->loginRef->username;
        }
        ?>
        <?php foreach($toList as $key=>$email) { ?>
            <div class="grid_2 pull">
                <input type="checkbox" value="<?php echo $email;?>" id="<?php echo $key;?>" class="toList">
                <label for="<?php echo $key;?>"><?php echo $key;?></label>
            </div>
        <?php } ?>
    </div>
    <div class="row multi_line no-gutter visible">
        <div class="gutter_vertical relative">
            <label class="color-gray" style="position: absolute; top: 8px; left: 10px;">Email To :</label>
            <?php
            echo $form->textField($model, 'email', array('placeholder'=>"Enter Emails with comma separated", 'class'=>'input full-width emailList','style'=>'padding-left: 80px;'));
            echo $form->error($model, 'email', array("class" => "errorMessage popup"));
            ?>
        </div>

        <div class="gutter_vertical relative">
            <?php
            echo $form->dropDownList(
                $model,'interaction_ref_id',
                CHtml::listData(MasterInteraction::model()->findAll(), 'interaction_id', 'interaction_type'),
                array('empty' => 'Mode of Interaction', 'class' => 'input full-width')
            );
            echo $form->error($model, 'interaction_ref_id', array("class" => "errorMessage popup"));
            ?>
        </div>

        <div class="gutter_vertical relative">
            <?php
            $this->widget('ext.editMe.widgets.ExtEditMe', array(
                'model'=>$model,
                'attribute'=>'message',
                'id' => 'diss_message',
                'toolbar'=>[
                    ['Bold', '-', 'Italic', '-', 'Underline'],
                    ['Link','-', 'Unlink','-', 'SpecialChar'],
                ],
                'ckeConfig'=>[
                    'enterMode'=>2, 'resize_enabled'=>false,
                    'removePlugins'=>'elementspath',
                    'placeholder' => 'Enter your message',
                ],
            ));
            echo $form->error($model, 'message', array("class" => "errorMessage popup"));
            ?>
        </div>
    </div>
    <div class="center">
        <?php echo CHtml::button('Preview', array('class' => 'previewBtn button-blue tny')); ?>
        <?php echo CHtml::submitButton('Send', array('value' => 'Send', 'class' => "sendBtn button-green tny")); ?>
    </div>
</div>
<?php $this->endWidget(); ?>

<style>
    #colorbox, #cboxOverlay, #cboxWrapper{
        z-index: 1000000;
    }
</style>
<script>
    var comment = $('#UserDataPoint_comments').val();
    $('#diss_message').val(comment);
    $('#ShareDiscussion_interaction_ref_id').val($('#UserDataPoint_interaction_ref_id').val());

    $("body").on('focus', 'input, select',function(){
        $(this).next('div.errorMessage').hide('slow');
    });

    function postData(form){
        var datastring = $(form).serialize()+'&uid='+milestoneStudentID;
        $('.sendBtn').attr('disabled', 'disabled').val('Please wait...')
        $.post(ibase_url + "milestoneprogress/default/shareDiscussion", datastring, function(){
            $.fancybox.close();
            $.notification({
                class: "success_notify",
                notification: "notification_geniric",
                replaceKeys: {MESSAGE: "Message sent successfully."}
            });
            $(".noteSection").load(ibase_url + "milestoneprogress/default/notes?uid="+milestoneStudentID);
        });
    }

    $('.previewBtn').on('click', function(e){
        e.preventDefault();
        $.colorbox({href:ibase_url + "milestoneprogress/default/previewShareDiscussion", data: $('#shareDiscussionData').serializeArray(), width:"850px", height:"650px", onComplete:function(){  } });
    });

</script>