<?php

class CUmailForm extends CFormModel {
    
    public $error_string;
    
    public $query_type_id;
    public $subject;
    public $message;
    public $attachments;
    public $header_id = NULL;
    
    //internal
    private $recipient_type;
    private $recipient_id;
    private $auto_escalate_advisor_id;
    private $auto_escalate = FALSE;
    private $message_id;
    private $message_type;



    public function rules() {
        return [
            ['query_type_id, subject, message', 'required'],
            ['subject', 'length', 'min' => 5, 'max' => 250],
            ['message', 'length', 'min' => 10, 'max' => 5000],

        ];
    }

    public function attributeLabels() {
        return [
            'query_type_id' => 'Umail Type',
            'subject' => 'Umail Subject',
            'message' => 'Umail Message',
        ];
    }

    public function _ce($error) {
        return '<div class="holder"><p>' . $error . '</p></div>';
    }

    public function addError($attribute, $error) {
        parent::addError($attribute, $this->_ce($error));
    }


    public function compose_and_send($User){
        
        $this->_find_to_address($User);
        $this->_compose_new($User);

        $this->_add_umail_log($User);
        //$this->_send_email($User);
        
        $LoginMaster = LoginMaster::model()->findByPk($User->login_ref_id);
        $LoginMaster->new_umail = 1;
        $LoginMaster->save(FALSE);
        
        return $this->error_string ? FALSE : TRUE;
    }
    
    protected function _send_email($User){
       
        $fldUserFullName = $User->first_name.' '.$User->last_name;
        $fldUserName = Yii::app()->db->createCommand('SELECT admin_name FROM tbl_admin WHERE admin_id = '.$this->recipient_id)->queryScalar();
        $fldMessage = $this->message;
        $fldQueryType =	Yii::app()->db->createCommand('SELECT type_name FROM query_type WHERE type_id = '.$this->query_type_id)->queryScalar();
        $year = date("Y");
        ob_start();
        include(Yii::app()->params['docRootPath']."/mail_template/umail_to_advisor.php");
        $message_body = ob_get_contents();
        ob_end_clean();
        
        $message = [];
        $message['subject'] = $this->subject;
        $message['body']    = $message_body;
        $message['type']    = 'UmailAdvisor';
        $message['toName']  = $fldUserName;
        $message['toEmail'] = Yii::app()->db->createCommand('SELECT admin_email FROM tbl_admin WHERE admin_id = '.$this->recipient_id)->queryScalar();
        $message['apiKey']  = Yii::app()->params['emailCron']['curlKey'];
        
        $emailq  = new EmailMessage;
        $emailq->addEmailMessage($message);
        
        return TRUE;
        
    }

    protected function _add_umail_log($User){
        
        $current_advisor = Yii::app()->db->createCommand('SELECT current_advisor FROM umail_log WHERE header_ref_id = '.$this->header_id)->queryScalar(); 
        if(!$current_advisor){
            $current_advisor = $this->recipient_id;
        }
       
        $log_data = [$this->message_type];
        $log_time = [date("Y-m-d H:i:s")];

        foreach($log_data as $index => $value){
            $Umaillog = new UmailLog;
            $Umaillog->setAttributes([
                'header_ref_id'     => $this->header_id,
                'message_ref_id'    => $this->message_id,
                'action_type'       => $value,
                'current_advisor'   => $current_advisor,
                'new_advisor'       => $this->recipient_id,
                'added_on'          => $log_time[$index],
                'sender_type'       => 1,
                'sender_id'         => $User->user_id,
            ], FALSE);
            if(!$Umaillog->save(FALSE)){
                $this->error_string = 'umail log save failed';
                return FALSE;
            }
        }
        
        return TRUE;
    }


    protected function _compose_new($User){
        
        $UmailHeader = new UmailHeader;
        $UmailHeader->setAttributes([
            'sender_type'           => 1,
            'sender_id'             => $User->user_id,
            'recipient_type'        => $this->recipient_type,
            'recipient_id'          => $this->recipient_id,
            'querytype_id'          => $this->query_type_id,
            'added_on'              => date('Y-m-d H:i:s'),
            'last_replied_on'       => date('Y-m-d H:i:s'),
            'original_advisor_id'   => $this->recipient_id,
            'current_advisor_id'    => $this->recipient_id,
            'status'                => 'NEW',
            'escalate_advisor_id'   => $this->auto_escalate_advisor_id,
        ], FALSE);
        $transaction = Yii::app()->db->beginTransaction();
        try {
            if(!$UmailHeader->save(FALSE)) throw new CDbException('umail header save failed');
            $this->header_id = $UmailHeader->header_id;
            
            $UmailCount = UmailMessage::model()->find('added_on > DATE_SUB(CURDATE(), INTERVAL 24 HOUR) AND sender_id = '.$User->user_id.' AND sender_type = 1');
            $day = ($UmailCount >= 3) ? 4 : 2;
            $last_date = $this->getWorkingDays2(date("Y-m-d H:i"),$day);
            $last_val = $last_date['next'];	
            $expected_date = end($last_val);						
            $UmailMessage = new UmailMessage;
            $UmailMessage->setAttributes([
                'header_ref_id'         => $UmailHeader->header_id,
                'sender_type'           => 1,
                'sender_id'             => $User->user_id,
                'recipient_type'        => $this->recipient_type,
                'recipient_id'          => $this->recipient_id,
                'added_on'              => date('Y-m-d H:i:s'),
                'message'               => $this->message,
                'subject'               => $this->subject,
                'workplan_steps'        => '',
                'expected_reply_date'   => $expected_date,
                'message_ref_id'        => NULL,
                'auto_escalate'         => $this->auto_escalate,
            ], FALSE);
            
            if(!$UmailMessage->save(FALSE)){
                throw new CDbException('umail message saving failed');
            }
            $this->message_id = $UmailMessage->message_id;
            
            $transaction->commit();
        } catch (Exception $exc) {
            $transaction->rollback();
            $this->error_string = $exc->getMessage();
            return FALSE;
        }
        
        return TRUE;
    }

    protected function _find_to_address($User){

        $ProspectResult = Prospect::model()->find('user_ref_id = :user_id AND prospect_status IN ("InProgress", "ConfirmedToPay")', [':user_id' => $User->user_id]);
	
        if(!empty($ProspectResult) && ($User->membership_ref_id == 1 || $User->membership_ref_id == 2)){
                $this->recipient_type   = 2;
                $this->recipient_id     = $ProspectResult['advisor_ref_id'];
        }else if(!empty($User->membership_ref_id) && ($User->membership_ref_id == 3 || $User->membership_ref_id == 4)){
                $this->recipient_type   = 2;
                $this->recipient_id     = Yii::app()->db->createCommand('SELECT primary_advisor_ref_id FROM student_assigned_advisor WHERE user_ref_id = '.$User->user_id)->queryScalar();
        }else if($User->membership_ref_id == 2){
                $ISQL = sprintf('SELECT tsidi.auto_escalate_flag,tsidi.auto_escalate_interval FROM tbl_si_di tsidi LEFT JOIN tbl_si_students tss ON tss.inst_ref_id = tsidi.inst_id WHERE tss.user_ref_id = %d', $User->user_id);
                $InstResult = Yii::app()->db->createCommand($ISQL)->queryRow();
                if(!empty($InstResult) && ($InstResult['auto_escalate_flag'] == 'Y'  && $InstResult['auto_escalate_interval'] == '0')){
                    $this->recipient_id     = Yii::app()->db->createCommand('SELECT admin_id FROM tbl_admin WHERE admin_name = "Unassigned"')->queryScalar();
                    $this->recipient_type   = 2;
                    //add auto-escalate-advisor-id in umail_header
                    $ESQL = sprintf('SELECT ta.admin_id FROM tbl_si_students tss JOIN tbl_si_di tsd ON tsd.inst_id = tss.inst_ref_id JOIN tbl_admin ta ON ta.login_ref_id = tsd.login_ref_id WHERE tss.user_ref_id = %d', $User->user_id);
                    $this->auto_escalate_advisor_id = Yii::app()->db->createCommand($ESQL)->queryScalar();
                    $this->auto_escalate = TRUE;
                }else {
                    $SQL = sprintf('SELECT ta.admin_id, ta.si_ref_id FROM tbl_admin ta LEFT JOIN tbl_si_di tsidi ON ta.si_ref_id = tsidi.inst_id LEFT JOIN tbl_si_students tss ON tss.inst_ref_id = tsidi.inst_id left join tbl_user_master tum on tum.user_id = tss.user_ref_id WHERE tss.user_ref_id = %d AND ta.is_active = "Y" AND ta.is_primary_si=1 AND tsidi.css_access=1 AND tum.membership_ref_id NOT IN (SELECT membership_id FROM lookup_membership WHERE membership_name IN ("GEM Student", "SI and GEM Student"))', $User->user_id);
                    $Result = Yii::app()->db->createCommand($SQL)->queryRow();
                    $this->recipient_id     = (isset($Result['admin_id'])) ? $Result['admin_id'] : '';
                    $this->recipient_type   = (isset($Result['si_ref_id'])) ? 4 : 2;
                }
        }
        $flag_unassigned = FALSE;
        // If advisor not assigned or not found then assign this umail to 'Unassigned' advisor user
        if(!$this->recipient_id){
                $flag_unassigned = TRUE;
        }else{
                //If advisor is in_active then change advisor as UNASSIGNED
                $isActiveAdvisor =	Yii::app()->db->createCommand('SELECT is_active FROM tbl_admin WHERE admin_id = '.$this->recipient_id)->queryScalar();
                if($isActiveAdvisor == 'N'){
                    $flag_unassigned = TRUE;
                }
        }
        if($flag_unassigned){
                $this->recipient_id     = Yii::app()->db->createCommand('SELECT admin_id FROM tbl_admin WHERE admin_name = "Unassigned"')->queryScalar();
                $this->recipient_type   = 2;
        }

            return TRUE;
    }
    
    private function getWorkingDays2($date, $workingday){
        $workdays['next'] = [];
        $holidays = CHtml::listData(LookupHoliday::model()->findAll(), 'dates', 'dates');
        $date = strtotime($date);
        $start_date = $date;
        $date = $start_date;
        while(count($workdays['next']) <= $workingday){
            if(date('N',$date) <= 7 && !in_array(date('Y-m-d',$date),$holidays)) $workdays['next'][] = date('Y-m-d H:i',$date);
            $date = strtotime("+1 day", $date);
        }
        return $workdays;
    }
    
}


