<?php

/*
 * @author zeevy
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseWebinarEvent');

class WebinarEvent extends BaseWebinarEvent{
    
    public static function model($className=__CLASS__){
        return parent::model($className);
    }
    
    public function rules(){
        return array(
            //array('speaker_name,speaker_designation,speaker_org','required','message' => '<div class="holder">{attribute} cannot be blank</div>'),
            //array('speaker_name_visible,speaker_desig_visible,speaker_org_visible','required','message' => '<div class="holder">Please Select Visibility</div>'),
            array('speaker_designation, speaker_org, speaker_name', 'length', 'max'=>100,'message' => '<div class="holder">{attribute} max characters 100 </div>'),
            array('speaker_name','match','pattern' => '/^[a-zA-Z\s]+$/','message' => '<div class="holder" >invalid charecters in {attribute}</div>'),
            array('event_video_url','match','pattern' => '/^(?:https?:\/\/)?(?:www\.)?youtube\.com\/watch\?(?=.*v=((\w|-){11}))(?:\S+)?$/','message' => '<div class="holder">Please provide valid youtube url</div>'),
            array('speaker_sign', 'file','types'=>'jpg, jpeg, png', 'allowEmpty'=>true),
        );
    }
    
    public function upload_file($attribute, $upload_path){
        $uploaded_file = CUploadedFile::getInstance($this,$attribute);
        $upload_path = trim(preg_replace('!/+$!','',  $upload_path));
        if(!is_dir($upload_path)) mkdir($upload_path, 0777, TRUE);

        if(!empty($uploaded_file)){
            if(!strlen($this->$attribute)){
                $extension = pathinfo($uploaded_file->name, PATHINFO_EXTENSION);
                $file_name = Yii::app()->db->createCommand('select UUID()')->queryScalar().'.'.$extension;
                $this->$attribute = $file_name;
            }
            $uploaded_file->saveAs($upload_path.DIRECTORY_SEPARATOR.$this->$attribute, TRUE);
        }
        return true;
    }

    public static function past_events($strtotime_string = '-3 days'){
        
        $criteria = new CDbCriteria();
        $old_time_zone = date_default_timezone_get();
        date_default_timezone_set('UTC');
        
        $event_date = DateTime::createFromFormat('YmdHis', date('YmdHis',strtotime($strtotime_string)))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d');
//        $last_week = DateTime::createFromFormat('YmdHis', date('YmdHis',strtotime('-7 days')))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d');
//        $today = DateTime::createFromFormat('YmdHis', date('YmdHis'))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d');
        date_default_timezone_set($old_time_zone);
        
        $with = array(
            'tblEventsCountries' => array('select' => 'country_ref_id'),
            'tblEventsCountries.countryRef' => array('select' => 'country_name,country_id'),
            'tblEventsDepartments' => array('select' => 'department_ref_id'),
            'tblEventsDepartments.departmentRef' => array('select' => 'department_id,department_name'),
        );
        
        //$criteria->addBetweenCondition('DATE(t.event_start_time)', $last_week, $today, 'AND');
        $criteria->addCondition('t.is_active = "Y" AND t.is_test = "N" AND t.event_video_url IS NOT NULL AND DATE(t.event_end_time) = :event_date');
        $criteria->params = array(':event_date' => $event_date);
        $criteria->with = $with;
        $criteria->order = 't.event_start_time ASC';
        
        $past_events_in_last_week = array();
        $results = WebinarEvent::model()->findAll($criteria);
        
        foreach($results as $r){
            $past_events_in_last_week[$r->event_id]['Event'] = $r->attributes;
            foreach($r->tblEventsCountries as $country){
                $past_events_in_last_week[$r->event_id]['Countries'][$country->countryRef->country_id] = $country->countryRef->country_name;
            }
            
            foreach($r->tblEventsDepartments as $department){
                $past_events_in_last_week[$r->event_id]['Departments'][$department->departmentRef->department_id] = $department->departmentRef->department_name;
            }
            //$upcoming_events_in_current_week[$r->event_id]['Countries'] = CHtml::listData($r->tblEventsCountries, 'country_ref_id', 'country_ref_id');
            //$upcoming_events_in_current_week[$r->event_id]['Departments'] = CHtml::listData($r->tblEventsDepartments, 'department_ref_id', 'department_ref_id');
        }
        
        return $past_events_in_last_week;
    }
    
    
    public static function upcoming_events_in_current_week(){
        
        $criteria = new CDbCriteria();
        $old_time_zone = date_default_timezone_get();
        date_default_timezone_set('UTC');
        $next_sunday = DateTime::createFromFormat('YmdHis', date('YmdHis',strtotime('+7 days')))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d');
        $today = DateTime::createFromFormat('YmdHis', date('YmdHis'))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d');
        date_default_timezone_set($old_time_zone);
        
        $with = array(
            'tblEventsCountries' => array('select' => 'country_ref_id'),
            'tblEventsCountries.countryRef' => array('select' => 'country_name,country_id'),
            'tblEventsDepartments' => array('select' => 'department_ref_id'),
            'tblEventsDepartments.departmentRef' => array('select' => 'department_id,department_name'),
        );
        
        $criteria->addBetweenCondition('DATE(t.event_start_time)', $today, $next_sunday, 'AND');
        $criteria->addCondition('t.is_active = "Y" AND t.is_test = "N"');
        $criteria->with = $with;
        $criteria->order = 't.event_start_time ASC';
        
        $upcoming_events_in_current_week = array();
        $results = WebinarEvent::model()->findAll($criteria);
        
        foreach($results as $r){
            $upcoming_events_in_current_week[$r->event_id]['Event'] = $r->attributes;
            foreach($r->tblEventsCountries as $country){
                $upcoming_events_in_current_week[$r->event_id]['Countries'][$country->countryRef->country_id] = $country->countryRef->country_name;
            }
            
            foreach($r->tblEventsDepartments as $department){
                $upcoming_events_in_current_week[$r->event_id]['Departments'][$department->departmentRef->department_id] = $department->departmentRef->department_name;
            }
            //$upcoming_events_in_current_week[$r->event_id]['Countries'] = CHtml::listData($r->tblEventsCountries, 'country_ref_id', 'country_ref_id');
            //$upcoming_events_in_current_week[$r->event_id]['Departments'] = CHtml::listData($r->tblEventsDepartments, 'department_ref_id', 'department_ref_id');
        }
        
        return $upcoming_events_in_current_week;
    }
    
    public static function get_upcoming_events($filters = array(),$with_unlisted_events = true){
        
        $criteria = new CDbCriteria();
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'));
        $now->setTimeZone(new DateTimeZone('UTC'));
        $criteria->addCondition('t.event_start_time > "'.$now->format('Y-m-d H:i:s').'"', 'AND');
        $criteria->addCondition('tblEventsCountries.country_ref_id IS NOT NULL', 'AND');
        
        $with = array(
            'tblEventsCountries' => array('select' => 'country_ref_id'),
            'tblEventsCountries.countryRef' => array('select' => 'country_name,country_id'),
            'tblEventsDepartments' => array('select' => 'department_ref_id'),
            'tblEventsDepartments.departmentRef' => array('select' => 'department_name,department_id'),
        );
        
        if($filters['country']) $with['tblEventsCountries']['condition'] = 'country_ref_id IN ('.$filters['country'].") ";
        if($filters['major']) $with['tblEventsDepartments']['condition'] = 'department_ref_id IN ('.$filters['major'].") ";
        if($filters['counselor']) $criteria->addCondition ('t.speaker_name = "'.$filters['counselor'].'"', 'AND');
        if($filters['event_name']) $criteria->addCondition ('t.event_title LIKE "%'.$filters['event_name'].'%"', 'AND');
        if(isset($filters['is_active'])){
            $criteria->addCondition('t.is_active = "'.$filters['is_active'].'"', 'AND');
        }        
        if(isset($filters['order'])){
            $criteria->order = $filters['order'];
        }else{
            $criteria->order = 't.event_start_time desc';
        }
        
        
        $criteria->with = $with;
        $result = WebinarEvent::model()->findAll($criteria);
        
        $Events = array();
        if($with_unlisted_events) $Events = self::get_upcoming_unlisted_events($filters);
        $countries = array();
        $departments = array();
        $presenters = array();
        
        foreach($result as $event_index => $event){
            foreach($event->tblEventsCountries as $country){
                $countries[$country->countryRef->country_id] = $country->countryRef->country_name;
                $Events[$country->countryRef->country_name][$event_index]['Event'] = $event->attributes;
                $Events[$country->countryRef->country_name][$event_index]['Country'][$country->countryRef->country_id] = $country->countryRef->country_name;
                if($event->speaker_name) $presenters[$event->speaker_name] = $event->speaker_name;
                foreach($event->tblEventsDepartments as $dept){
                    $Events[$country->countryRef->country_name][$event_index]['Department'][$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                    $departments[$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                }
            }
        }
        
        asort($countries); asort($departments); asort($presenters);
        
        return compact('Events','countries','departments','presenters');
    }
    
    public static function get_upcoming_unlisted_events($filters){
        
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'));
        $now->setTimeZone(new DateTimeZone('UTC'));
        $command = Yii::app()->db->createCommand()
                ->from('tbl_event e')
                ->leftJoin('tbl_events_countries c', 'c.event_ref_id = e.event_id')
                ->leftJoin('tbl_events_departments d','d.event_ref_id = e.event_id');
        
        if($filters['event_name']){
            $where = 'c.event_ref_id IS NULL AND e.event_start_time > "'.$now->format('Y-m-d H:i:s').'" AND e.event_title LIKE "%'.$filters['event_name'].'%"';
        }else{
            $where = 'c.event_ref_id IS NULL AND e.event_start_time > "'.$now->format('Y-m-d H:i:s').'"';
        }
        
        $command->where($where);
        $command->order('e.event_start_time desc');
        
        
        $upcoming_unlisted_events = array();
        foreach($command->queryAll() as $event){
            $upcoming_unlisted_events['Unlisted'][]['Event'] = $event;
        }
        return $upcoming_unlisted_events;
    }

    public static function get_past_events($filters = array(),$with_unlisted_events = true){
        
        $criteria = new CDbCriteria();
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $criteria->addCondition('t.event_end_time < "'.$now->format('Y-m-d H:i:s').'"', 'AND');
        $criteria->addCondition('tblEventsCountries.country_ref_id IS NOT NULL', 'AND');
        
        $with = array(
            'tblEventsCountries' => array('select' => 'country_ref_id'),
            'tblEventsCountries.countryRef' => array('select' => 'country_name,country_id'),
            'tblEventsDepartments' => array('select' => 'department_ref_id'),
            'tblEventsDepartments.departmentRef' => array('select' => 'department_name,department_id'),
        );
        
        if($filters['country']) $with['tblEventsCountries']['condition'] = 'country_ref_id = '.$filters['country'];
        if($filters['major']) $with['tblEventsDepartments']['condition'] = 'department_ref_id = '.$filters['major'];
        if($filters['counselor']) $criteria->addCondition ('t.speaker_name = "'.$filters['counselor'].'"', 'AND');
        if($filters['event_name']) $criteria->addCondition ('t.event_title LIKE "%'.$filters['event_name'].'%"', 'AND');
        if(isset($filters['is_active'])){
            $criteria->addCondition('t.is_active = "'.$filters['is_active'].'"', 'AND');
        }
        if(isset($filters['order'])){
            $criteria->order = $filters['order'];
        }else{
            $criteria->order = 't.event_start_time desc';
        }
        

        $criteria->with = $with;
        $result = WebinarEvent::model()->findAll($criteria);

        $Events = array();
        if($with_unlisted_events) $Events = self::get_past_unlisted_events($filters);
        $countries = array();
        $departments = array();
        $presenters = array();
        
        foreach($result as $event_index => $event){
            foreach($event->tblEventsCountries as $country){
                $countries[$country->countryRef->country_id] = $country->countryRef->country_name;
                $Events[$country->countryRef->country_name][$event_index]['Event'] = $event->attributes;
                $Events[$country->countryRef->country_name][$event_index]['Country'][$country->countryRef->country_id] = $country->countryRef->country_name;
                if($event->speaker_name) $presenters[$event->speaker_name] = $event->speaker_name;
                foreach($event->tblEventsDepartments as $dept){
                    $Events[$country->countryRef->country_name][$event_index]['Department'][$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                    $departments[$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                }
            }
        }
        asort($countries); asort($departments); asort($presenters);
        return compact('Events','countries','departments','presenters');
    }
    
    public static function get_past_unlisted_events($filters){
        
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $command = Yii::app()->db->createCommand()
                ->from('tbl_event e')
                ->leftJoin('tbl_events_countries c', 'c.event_ref_id = e.event_id')
                ->leftJoin('tbl_events_departments d','d.event_ref_id = e.event_id');
        
        if($filters['event_name']){
            $where = 'c.event_ref_id IS NULL AND e.event_end_time < "'.$now->format('Y-m-d H:i:s').'" AND e.event_title LIKE "%'.$filters['event_name'].'%"';
        }else{
            $where = 'c.event_ref_id IS NULL AND e.event_end_time < "'.$now->format('Y-m-d H:i:s').'"';
        }

        if(isset($filters['is_active'])){
            $where .= ' AND e.is_active = "'.$filters['is_active'].'"';
        }
        
        $command->where($where);
        $command->order('e.event_start_time desc');
        
        $past_unlisted_events = array();
        foreach($command->queryAll() as $event){
            $past_unlisted_events['Unlisted'][]['Event'] = $event;
        }
        return $past_unlisted_events;
    }
    
    public static function get_event_countries($event_id){
        if(!$event_id || !WebinarEvent::model()->exists('event_id = :id',array(':id' => $event_id))) return array();
        
        $command = Yii::app()->db->createCommand()
                ->select('ec.tbl_events_countries_id as id,cm.country_name as name')
                ->from('tbl_events_countries ec')
                ->join('tbl_country_master cm', 'cm.country_id = ec.country_ref_id')
                ->where('ec.event_ref_id = :event_id', array('event_id' => $event_id));
        return CHtml::listData($command->queryAll(),'id','name');
        
    }

    public static function get_event_majors($event_id){
        if(!$event_id || !WebinarEvent::model()->exists('event_id = :id',array(':id' => $event_id))) return array();
        
        $command = Yii::app()->db->createCommand()
                ->select('ed.tbl_events_departments_id as id, ld.department_name as name')
                ->from('tbl_events_departments ed')
                ->join('lookup_department ld', 'ld.department_id = ed.department_ref_id')
                ->where('ed.event_ref_id = :event_id', array('event_id' => $event_id));
        return CHtml::listData($command->queryAll(),'id','name');
    }
    
    public static function get_comments($event_id, $offset = 0, $limit = 10){
        
        $command = Yii::app()->db->createCommand()
                ->select('c.login_ref_id,c.event_comment,c.added_on,u.user_photo,u.first_name,u.last_name,u.gender')
                ->from('tbl_event_comments c')
                ->join('tbl_user_master u', 'u.login_ref_id = c.login_ref_id')
                ->where('c.is_active = "Y" AND c.parent_id is NULL AND c.event_ref_id = :id',array(':id' => $event_id))
                ->order('c.added_on desc')
                ->offset($offset)
                ->limit($limit);
        return $command->queryAll();
    }
    
    public static function get_update_pending_events(){
        
        $criteria = new CDbCriteria();
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis',strtotime('-2 days')), new DateTimeZone('UTC'));
        $criteria->condition = 'DATE(t.event_end_time) < :time AND (t.is_registrants_copied = "0" || t.is_attendees_copied = "0") AND t.is_active = "Y"';
        $criteria->params = array(':time' => $now->format('Y-m-d'));
        
        $result = WebinarEvent::model()->findAll($criteria);
        
        return $result?$result:array();
    }
    
    public static function webinars_in_next_n_hour($strtotime_string = '+1 hour'){
        
        $old_time_zone = date_default_timezone_get();
        date_default_timezone_set('UTC');
        $start_time = DateTime::createFromFormat('YmdHis', date('YmdHis'))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
        $end_time = DateTime::createFromFormat('YmdHis', date('YmdHis',strtotime($strtotime_string)))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
        date_default_timezone_set($old_time_zone);
        
        $criteria = new CDbCriteria();
        $criteria->addBetweenCondition('t.event_start_time', $start_time, $end_time, 'AND');
        $criteria->addCondition('t.is_active = "Y" AND t.is_test = "N"');
        $criteria->order = 't.event_start_time ASC';
        
        $webinars = array();
        foreach(WebinarEvent::model()->findAll($criteria) as $result){
            $webinars[$result->event_id] = $result->attributes;
        }
        
        return $webinars;
    }
    
    public static function student_attended_webinars($filters = array()){
        $events = array(); $countries = array(); $departments = array(); $year = array(); $month = array(); $country_departments = array();
        
        $default_filters = array('country' => null, 'major' => null, 'event_name' => null, 'year' => null, 'month' => null);
        $filters = array_replace($default_filters, $filters);
        
        $db_results = Yii::app()->db->createCommand()
                ->select('EventAttendees.event_ref_id, EventAttendees.attendance_time_seconds, TIMESTAMPDIFF(SECOND, WebinarEvent.event_start_time, WebinarEvent.event_end_time) AS event_time_in_seconds')
                ->from(EventAttendees::model()->tableSchema->name.' EventAttendees')
                ->join(WebinarEvent::model()->tableSchema->name. ' WebinarEvent', 'WebinarEvent.event_id = EventAttendees.event_ref_id AND WebinarEvent.is_attendees_copied = "1" AND WebinarEvent.is_active = "Y"')
                ->where('EventAttendees.user_ref_id = '. Yii::app()->user->sub_id)
                ->having('attendance_time_seconds >= ((70/100) * event_time_in_seconds)')
                ->queryAll();
                
        $student_attended_events = CHtml::listData($db_results, 'event_ref_id', 'event_ref_id');
        if(empty($student_attended_events)) return compact('events','countries','departments','country_departments','year','month');
        
        $criteria = new CDbCriteria();
        $criteria->select = 't.event_id, t.webinar_key, t.event_title, t.event_start_time, t.event_end_time, t.timezone';
        
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $criteria->addCondition('t.event_end_time < "'.$now->format('Y-m-d H:i:s').'"', 'AND');
        $criteria->addCondition('t.is_attendees_copied = "1" AND t.is_active = "Y"', 'AND');
        $criteria->addInCondition('t.event_id', $student_attended_events, 'AND');
        
        $with = array(
            'tblEventsCountries' => array('select' => 'country_ref_id'),
            'tblEventsCountries.countryRef' => array('select' => 'country_name,country_id'),
            'tblEventsDepartments' => array('select' => 'department_ref_id'),
            'tblEventsDepartments.departmentRef' => array('select' => 'department_name,department_id'),
        );
        
        if($filters['country']) $with['tblEventsCountries']['condition'] = 'country_ref_id = '.$filters['country'];
        if($filters['major']) $with['tblEventsDepartments']['condition'] = 'department_ref_id = '.$filters['major'];
        if($filters['event_name']) $criteria->addCondition ('t.event_title LIKE "%'.$filters['event_name'].'%"', 'AND');
        if($filters['year']) $criteria->addCondition('YEAR(t.event_start_time) = '.$filters['year']);
        if($filters['month']) $criteria->addCondition('MONTH(t.event_start_time) = '.$filters['month']);
        $criteria->order = 't.event_start_time desc';
        $criteria->group = 't.event_id';
        
        $criteria->with = $with;
        $result = WebinarEvent::model()->findAll($criteria);
        
        foreach($result as $event){
            $events[$event->event_id]['Event'] = $event->attributes;
            foreach($event->tblEventsCountries as $country){
                $countries[$country->countryRef->country_id] = $country->countryRef->country_name;
                $events[$event->event_id]['Country'][$country->countryRef->country_id] = $country->countryRef->country_name;
                foreach($event->tblEventsDepartments as $dept){
                    $country_departments[$country->countryRef->country_id][$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                    $departments[$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                    $events[$event->event_id]['Department'][$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
                }
                $event_year = date('Y', strtotime($event->event_start_time));
                $year[$event_year] = $event_year;
                $month[date('m', strtotime($event->event_start_time))] = date('M', strtotime($event->event_start_time));
            }
        }
        asort($countries); asort($departments); ksort($month); asort($year);
        return compact('events','countries','departments','country_departments','year','month');
    }
    
    public static function certificate_events($strtotime_string = '-3 days'){
        
        $event_date = DateTime::createFromFormat('YmdHis', date('YmdHis',strtotime($strtotime_string)))->setTimeZone(new DateTimeZone('UTC'))->format('Y-m-d');
        $results = Yii::app()->db->createCommand()
                ->select('EventAttendees.event_ref_id, EventAttendees.user_ref_id, EventAttendees.first_name, EventAttendees.last_name, EventAttendees.email, EventAttendees.attendance_time_seconds, TIMESTAMPDIFF(SECOND, WebinarEvent.event_start_time, WebinarEvent.event_end_time) AS event_time_in_seconds, WebinarEvent.*')
                ->from(EventAttendees::model()->tableSchema->name.' EventAttendees')
                ->join(WebinarEvent::model()->tableSchema->name. ' WebinarEvent', 'WebinarEvent.event_id = EventAttendees.event_ref_id AND WebinarEvent.is_attendees_copied = "1" AND WebinarEvent.is_active = "Y"')
                ->where('DATE(WebinarEvent.event_end_time) = :event_date AND EventAttendees.user_ref_id IS NOT NULL', array(':event_date' => $event_date))
                ->having('attendance_time_seconds >= ((70/100) * event_time_in_seconds)')
                ->queryAll();
//                echo $event_date; exit;
        
        $students_and_events = array();
        
        foreach($results as $r){
            $students_and_events[$r['email']][] = $r;
        }
        
        return $students_and_events;
        
    }
    
    
    public static function get_events($filters = array(), $offset = 0, $limit = 10){
        $filters = array_filter($filters, 'strlen');
        date_default_timezone_set('UTC');
        $command = Yii::app()->db->createCommand()
                ->select('WebinarEvent.*, GROUP_CONCAT(DISTINCT(WebinarEventCountries.country_ref_id)) AS countries, GROUP_CONCAT(DISTINCT(WebinarEventDepartments.department_ref_id)) AS departments')
                ->from(WebinarEvent::model()->tableSchema->name.' WebinarEvent')
                ->join(WebinarEventCountries::model()->tableSchema->name.' WebinarEventCountries', 'WebinarEventCountries.event_ref_id = WebinarEvent.event_id')
                ->join(WebinarEventDepartments::model()->tableSchema->name.' WebinarEventDepartments', 'WebinarEventDepartments.event_ref_id = WebinarEvent.event_id');
                
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $event_where = ' WebinarEvent.event_end_time < :event_end_time AND WebinarEvent.event_video_url <> "" AND WebinarEvent.is_active = "Y" AND WebinarEvent.is_test = "N" ';
        $parameters = array(':event_end_time' => $now->format('Y-m-d H:i:s'));
        
        if(isset($filters['country']) && !empty($filters['country'])){
            $event_where .= ' AND WebinarEventCountries.country_ref_id IN ( '.$filters['country'].'  )';
            //$parameters['country_ref_id'] = $filters['country'];
        }
        
        if(isset($filters['major']) && !empty($filters['major'])){
            $event_where .= ' AND WebinarEventDepartments.department_ref_id IN( '.$filters['major'].' )';
            //$parameters[':department_ref_id'] = $filters['major'];
        }
        
        if(isset($filters['by_month'])){
            $event_where .= ' AND MONTH(WebinarEvent.event_end_time) = :by_month ';
            $parameters[':by_month'] = $filters['by_month'];
        }
        
        $command->where($event_where, $parameters);
        
        $result = $command->group('WebinarEvent.event_id')->order('WebinarEvent.event_start_time DESC')->limit($limit, $offset)->queryAll();
        $events = array();
        
        foreach($result as $event_index => $event){
            $events[$event_index]['Event'] = $event;
            $events[$event_index]['Country'] = Yii::app()->db->createCommand()->select('TblCountryMaster.country_id, TblCountryMaster.country_name')->from(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster')->where(array('IN', 'TblCountryMaster.country_id', explode(',', $event['countries'])))->queryAll();
            $events[$event_index]['Department'] = Yii::app()->db->createCommand()->select('LookupDepartment.department_id, LookupDepartment.department_name')->from(LookupDepartment::model()->tableSchema->name.' LookupDepartment')->where(array('IN', 'LookupDepartment.department_id', explode(',', $event['departments'])))->queryAll();
        }        
        return compact('events');
    }
    
    public static function get_events_count($filters = array()){
        $filters = array_filter($filters, 'strlen');
        date_default_timezone_set('UTC');
        $command = Yii::app()->db->createCommand()
                ->select('WebinarEvent.event_id')
                ->from(WebinarEvent::model()->tableSchema->name.' WebinarEvent')
                ->join(WebinarEventCountries::model()->tableSchema->name.' WebinarEventCountries', 'WebinarEventCountries.event_ref_id = WebinarEvent.event_id')
                ->join(WebinarEventDepartments::model()->tableSchema->name.' WebinarEventDepartments', 'WebinarEventDepartments.event_ref_id = WebinarEvent.event_id');
                
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $event_where = ' WebinarEvent.event_end_time < :event_end_time AND WebinarEvent.event_video_url <> "" AND WebinarEvent.is_active = "Y" AND WebinarEvent.is_test = "N" ';
        $parameters = array(':event_end_time' => $now->format('Y-m-d H:i:s'));
        
        if(isset($filters['country']) && !empty($filters['country'])){
            $event_where .= ' AND WebinarEventCountries.country_ref_id IN ( '.$filters['country'].'  )';
            //$parameters['country_ref_id'] = $filters['country'];
        }
        
        if(isset($filters['major']) && !empty($filters['major'])){
            $event_where .= ' AND WebinarEventDepartments.department_ref_id IN ( '.$filters['major'].' )';
            //$parameters[':department_ref_id'] = $filters['major'];
        }
        
        if(isset($filters['by_month'])){
            $event_where .= ' AND MONTH(WebinarEvent.event_end_time) = :by_month ';
            $parameters[':by_month'] = $filters['by_month'];
        }
        
        $command->where($event_where, $parameters);
        
        $result = $command->group('WebinarEvent.event_id')->order('WebinarEvent.event_start_time DESC')->queryAll();
        
        return count($result);
    }
    public static function _get_upcoming_events_list($filters=array(), $offset = false, $limit = false){
        $lt=10;
        $off=0;
        if($limit){
            $lt= $limit;
        }
        if($offset){
           $off= $offset;
        }
        $event_where="";
        if(isset($filters['country']) && !empty($filters['country'])){
            $event_where .= ' AND TblEventsCountries.country_ref_id IN ( '.$filters['country'].'  )';            
        }        
        if(isset($filters['major']) && !empty($filters['major'] )){
            $event_where .= ' AND TblEventsDepartments.department_ref_id IN ( '.$filters['major'].'  )';            
        }
        date_default_timezone_set('UTC');
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $result= Yii::app()->db->createCommand()
                ->select('WebinarEvent.*')
                ->from(WebinarEvent::model()->tableSchema->name.' WebinarEvent')
                ->join(WebinarEventCountries::model()->tableSchema->name.' TblEventsCountries', 'TblEventsCountries.event_ref_id = WebinarEvent.event_id')
                ->join(WebinarEventDepartments::model()->tableSchema->name.' TblEventsDepartments', 'TblEventsDepartments.event_ref_id = WebinarEvent.event_id')
                ->where('WebinarEvent.event_start_time > :today_time AND WebinarEvent.is_active = "Y" AND WebinarEvent.is_test = "N" '.$event_where, array(':today_time' => $now->format('Y-m-d H:i:s')))
                ->group('WebinarEvent.event_id')
                ->order('WebinarEvent.event_start_time ASC')
                ->limit($lt)
                ->offset($off)
                ->queryAll();
        
         foreach($result as $event_index => $event){
            $events[$event_index]['Event'] = $event;           
        }
        return compact('events');
    }
    
    
     public static function _get_upcoming_events_count($filters=array()){       
        $event_where="";
        if(isset($filters['country']) && !empty($filters['country'])){
            $event_where .= ' AND TblEventsCountries.country_ref_id IN ( '.$filters['country'].'  )';            
        }        
        if(isset($filters['major']) && !empty($filters['major'] )){
            $event_where .= ' AND TblEventsDepartments.department_ref_id IN ( '.$filters['major'].'  )';            
        }
        date_default_timezone_set('UTC');
        $now = DateTime::createFromFormat('YmdHis', date('YmdHis'), new DateTimeZone('UTC'));
        $result= Yii::app()->db->createCommand()
                ->select('WebinarEvent.*')
                ->from(WebinarEvent::model()->tableSchema->name.' WebinarEvent')
                ->join(WebinarEventCountries::model()->tableSchema->name.' TblEventsCountries', 'TblEventsCountries.event_ref_id = WebinarEvent.event_id')
                ->join(WebinarEventDepartments::model()->tableSchema->name.' TblEventsDepartments', 'TblEventsDepartments.event_ref_id = WebinarEvent.event_id')
                ->where('WebinarEvent.event_start_time > :today_time AND WebinarEvent.is_active = "Y" AND WebinarEvent.is_test = "N" '.$event_where, array(':today_time' => $now->format('Y-m-d H:i:s')))
                ->group('WebinarEvent.event_id')
                ->order('WebinarEvent.event_start_time ASC')               
                ->queryAll();        
        return count($result);
    }
    
    public static function get_event_details_by_webinar_key($webinar_key){
        
        $criteria = new CDbCriteria();
        $criteria->addCondition('tblEventsCountries.country_ref_id IS NOT NULL', 'AND');
        $criteria->addCondition('t.webinar_key = :webinar_key', 'AND');
        $criteria->params = array(':webinar_key' => $webinar_key);
        
        $with = array(
            'tblEventsCountries' => array('select' => 'country_ref_id'),
            'tblEventsCountries.countryRef' => array('select' => 'country_name,country_id'),
            'tblEventsDepartments' => array('select' => 'department_ref_id'),
            'tblEventsDepartments.departmentRef' => array('select' => 'department_name,department_id'),
            'webinarEventVideos' => array('select' => 'webinarEventVideos.title, webinarEventVideos.video_link, webinarEventVideos.is_promoted')
        );
        
        $criteria->with = $with;
        $result = WebinarEvent::model()->find($criteria);
        //return $result;
        
        $event['Event'] = $result->attributes;
        $event['Country'] = array();
        foreach($result->tblEventsCountries as $country) $event['Country'][$country->countryRef->country_id] = $country->countryRef->country_name;
        $event['Department'] = array();
        foreach($result->tblEventsDepartments as $dept) $event['Department'][$dept->departmentRef->department_id] = $dept->departmentRef->department_name;
        $event['Videos'] = array();
        foreach($result->webinarEventVideos as $video) $event['Videos'][] = $video->attributes;
        
        return $event;
        
    }
    
}