<?php 
$this->breadcrumbs=array(
    'Di Accounts'=>array('/diadmin/di/admin'),
    'Manage Pricing'=>array('/diadmin/di/managepricing/','id'=>$di_id),
    'Manage Campaign Settings',
);

Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/spectrum.css");
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/spectrum.js");
?>

<h1>Manage Email Campaign Settings</h1>
<div class="di_form">
    <div class="form">

        <?php $form=$this->beginWidget('CActiveForm', array(
        'id'=>'settings-form',
        'enableClientValidation'=>true,
        'clientOptions'=>array(
			'validateOnSubmit' => true,
			'beforeValidate'  => 'js:function(form){
				CKEDITOR.instances.DiEmailCampaignSettings_footer_content.updateElement();
				return true;
			}',
		),
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
        )); ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'template_color_code'); ?>
            <?php echo $form->textField($model,'template_color_code', array('class' => 'spectrum')); ?>
            <!-- <input type="color" name="template_color_code" value="<?php echo $model->template_color_code; ?>" /> -->

            <?php echo $form->error($model,'template_color_code'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'footer_content'); ?>
            <div style="width:650px; float: left">
            <?php
            $this->widget('ext.editMe.widgets.ExtEditMe', array(
                'model'=>$model,
                'attribute'=>'footer_content',
                'height'=>'250px',
                'width'=>'650px',
                'toolbar'=>array(
                    array('Bold', 'Italic', 'Underline'),
                    array('NumberedList', 'BulletedList','Blockquote'),
                    array('JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'),
                    array('Image', 'TextColor', 'BGColor',),
                    array('Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord'),
                    array('Link', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar'),
                    array('Source'),
                )
            ));
            ?>
            </div>
            <?php echo $form->error($model,'footer_content'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'logo_image'); ?>
            <?php
                echo $form->fileField($model,'logo_image');
                if($model->logo_image){ ?>
                    <a href="<?php echo Yii::app()->baseUrl.'/uploads/di_email_campaign_attachments/'.$model->logo_image; ?>" target="_blank"><img style="float:left;" src="<?php echo Yii::app()->baseUrl.'/uploads/di_email_campaign_attachments/'.$model->logo_image; ?>" width="100" height="75"/></a>
                <?php }
            ?>
            <?php echo $form->error($model,'logo_image'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'banner_image'); ?>
            <?php echo $form->fileField($model,'banner_image'); ?>
            <?php
            if($model->banner_image){ ?>
                <a href="<?php echo Yii::app()->baseUrl.'/uploads/di_email_campaign_attachments/'.$model->banner_image; ?>" target="_blank"><img style="float:left;" src="<?php echo Yii::app()->baseUrl.'/uploads/di_email_campaign_attachments/'.$model->banner_image; ?>" width="100" height="75"/></a>
                <?php }
            ?>
            <?php echo $form->error($model,'banner_image'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php echo $form->labelEx($model,'template_image'); ?>
            <?php echo $form->fileField($model,'template_image'); ?>
            <?php
            if($model->template_image){ ?>
                <a href="<?php echo Yii::app()->baseUrl.'/uploads/di_email_campaign_attachments/'.$model->template_image; ?>" target="_blank"><img style="float:left;" src="<?php echo Yii::app()->baseUrl.'/uploads/di_email_campaign_attachments/'.$model->template_image; ?>" width="100" height="75"/></a>
                <?php }
            ?>
            <?php echo $form->error($model,'template_image'); ?>
        </div>

        <div class="row buttons">
            <label>&nbsp;</label>
            <input type="submit" class="button" value="Save Settings" />
            <a href="#" class="button" id="previewTemplate">Preview Template</a>
        </div>

        <?php $this->endWidget(); ?>

    </div><!-- form -->
</div>
<script>
    $(function(){
        $(".spectrum").spectrum({
            preferredFormat: "hex",
            showInput: true
        });

        $('#previewTemplate').on('click', function(e){
            e.preventDefault();
            $.colorbox({href:ibase_url + "diadmin/diEmailCampaignSettings/previewTemplate/di_id/<?php echo $di_id; ?>", data: $('#settings-form').serializeArray(), width:"850px", height:"650px", onComplete:function(){  $.colorbox.resize() } });
        });
    })
</script>