<?php 
$this->breadcrumbs=array(
    'Manage DI Accounts'=>array('admin'),
	'Send Criteria Form',
);
?>
<style>
    fieldset .row {
        margin-bottom :10px !important;
    }
</style>
<h1>Send Criteria Form</h1>
<div class="di_form">

    <div class="form">
        <?php $form=$this->beginWidget('CActiveForm', array(
        'id'=>'di-form',
        'enableAjaxValidation'=>true,
        //'enableClientValidation'=>true,
        'clientOptions' =>array(
            'validateOnSubmit'=>true,
            'validateOnChange' => false,
            'beforeValidate'  => 'js:function(form){
                    $("div.errorMessage").hide();
                    return true;
            }',
            'afterValidate' => 'js:function(form, data, hasError){
                if(!$.isEmptyObject(data)){
                    for(var i in data) {
                       var id = i, message = data[i][0];
                       $("#"+i+"_em_").text(message).show();
                    }
                    return false;
                }else{
                    return true;
                }
            }',
        ),
    )); ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php // echo $form->errorSummary(array($model)); ?>

        <div class="row">
            <?php echo $form->labelEx($model,'uniname'); ?>
            <?php $this->widget('zii.widgets.jui.CJuiAutoComplete',
            array(
                'attribute'=>'uniname',
                'model'=>$model,
                'source' => $uniNames,
                'htmlOptions'=>array(
                    'placeholder'=>'Type / Select a University',
                    'style'=>'height:20px;',
                ),
                'options'=>array(
                    'autoFill'=>false,
                    'minLength'=>'2',
                ),
            )
        ); ?>
            <?php echo $form->error($model,'uniname'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model,'country'); ?>
            <?php echo $form->dropDownList($model,'country',
            CHtml::ListData(
                TblCountryMaster::model()->findAll(array('select'=>'t.country_id, t.country_name', 'order'=>'t.country_name', 'condition' => 't.is_active = "Y"')), 'country_id', 'country_name')
            , array('empty' => 'Select Country',
                    'ajax' => array(
                        'type'=>'GET',
                        'dataType'=>'json',
                        'url'=>Yii::app()->createUrl('diadmin/di/getCityList'),
                        'data'=>array('countryId'=>'js:this.value'),
                        'success'=>'function(data) {
                                $("#citydrpdwn").children("option:not(:first)").remove();
                                $.each(data, function(value, key) {
                                 $("#citydrpdwn").append("<option value="+key+">"+value+"</option>");
                              });
                        }',
                    )

            )); ?>
            <?php echo $form->error($model,'country'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model,'city'); ?>
            <?php echo $form->dropDownList($model,'city', array(), array('empty' => 'Select City', 'id' => 'citydrpdwn')); ?> (Optional)
            <?php echo $form->error($model,'city'); ?>
        </div>

        <fieldset style="width: 450px;" class="contactInfo">
            <legend>Contact Information: (All fields are required)</legend><p></p>
            <div class="row">
                <?php echo $form->labelEx($model,'contact_name'); ?>
                <?php echo $form->textField($model,'[0]contact_name'); ?>
                <?php echo $form->error($model,'[0]contact_name'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model,'contact_designation'); ?>
                <?php echo $form->textField($model,'[0]contact_designation'); ?>
                <?php echo $form->error($model,'[0]contact_designation'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model,'contact_email'); ?>
                <?php echo $form->textField($model,'[0]contact_email'); ?>
                <?php echo $form->error($model,'[0]contact_email'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model,'contact_number'); ?>
                <?php echo $form->textField($model,'[0]contact_number'); ?>
                <?php echo $form->error($model,'[0]contact_number'); ?>
            </div>
           <span style="display: none;" class="index">0</span>
        </fieldset>

        <p><a href="#" id="addContactInfo">+ Add More >> </a> </p>
        <div class="row buttons">
            <?php echo CHtml::submitButton('Invite',array('class'=>'button')); ?>
            <?php echo CHtml::button('Cancel',array('class'=>'button','onClick'=>'javascript:window.history.back()')); ?>
        </div>

        <?php $this->endWidget(); ?>

    </div>
</div>
<script type="text/javascript">
$(function(){

    var removeLink = ' <a class="remove button"  style="float: right" href="#" onclick="$(this).parent().slideUp(function(){ $(this).remove() }); return false">Remove X</a>';

    $('a#addContactInfo').on('click', function(e){
        e.preventDefault();
        var master = $('.contactInfo'),
            counter  = ~~master.find('span.index:last').text() + 1,
            parent = master.eq(0),
            clone = parent.clone();

        clone.find('input').attr('name', function(){
            var curName = $(this).attr('name');
            return curName.replace(/\d/g, counter);
        }).attr('id', function(){
            var curId = $(this).attr('id');
            return curId.replace(/\d/g, counter);
        }).val('');

        clone.find('div.errorMessage').attr('id', function(){
            var curId = $(this).attr('id');
            return curId.replace(/\d/g, counter);
        }).html('').hide();

        clone.find('span.index').text(counter);

        $(clone).append(removeLink).insertAfter($('.contactInfo:last')).hide().slideDown();
    })

});
</script>