<?php 

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiProductCredit is autogenerate by UniModel generator
 *
 * This is the model class for table "di_product_credit".
 *
 * The followings are the available columns in table 'di_product_credit':
 * @property string $di_product_credit_id
 * @property integer $di_ref_id
 * @property integer $product_ref_id
 * @property integer $credit_count
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property Di $diRef
 * @property LookupProduct $productRef
 */
class BaseDiProductCredit extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiProductCredit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_product_credit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id, product_ref_id, added_on, added_by', 'required'),
			array('di_ref_id, product_ref_id, credit_count', 'numerical', 'integerOnly'=>true),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_product_credit_id, di_ref_id, product_ref_id, credit_count, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'productRef' => array(self::BELONGS_TO, 'LookupProduct', 'product_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_product_credit_id' => 'Di Product Credit',
			'di_ref_id' => 'Di Ref',
			'product_ref_id' => 'Product Ref',
			'credit_count' => 'Credit Count',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_product_credit_id',$this->di_product_credit_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('product_ref_id',$this->product_ref_id);
		$criteria->compare('credit_count',$this->credit_count);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}