<?php
class HotleadAlermatchDuplicacyHandler extends CComponent{
   
   
   /* This will run when criteria cron pick enteries,
	So need tho check if any lead already exist in hotlead
	Then don't include it in Criteria Match
	*/
	static function ifAlreadyExistInHotlead(){
		// This functionality is already done in criteria
	}
   
   
   
   
	/*
	This function is for if student Apply on university in hotlead
	In runhotleadcron while enteries transfer from student_hotlead to di_user_hotlead
	We will add this check ifAlreadyExistInAlertMatch while before cron insert entery in di_user_hotlead
		this will return true or false
		true  : ignore hot lead part ( already processed in Alertmatch ) 
		false : insert record indi_user_hotlead  ( entery not exist in alertmatch )
	*/
	static function ifAlreadyExistInAlertMatch($user_id="",$uni_ref_id="",$applyStatus = ""){
		/*
		
		  this will return true or false
			true  : ignore hot lead part ( already processed in Alertmatch ) 
			false : Process in hotlead  ( entery not exist in alertmatch )
			
		  FLOW
		  first find record in di_user_eoi and di_user_eoi_log
		  if found
		  update eoi_status = Hotlead in both tables
		  else
		  find entery in di_user_criteria_match
		  if found
		  remove it ( because EOI is not sent , this record will be handeled in HotLead section )
		  else
		  no action required ( handel it in hotlead )
		*/
		
		// we will input with student id and university id
		// first find di_user_id for di admin of particular university
		
		/*
		$user_id = 145;
		$uni_ref_id = 166;
		$applyStatus = ""; //Applied|MightApply|Reject|WillApply
		*/
		
			if($applyStatus!="Reject"){
				$applyStatus = "Accept";
			}
		
		$Di = Di::model()->findByAttributes(array('uni_ref_id'=>$uni_ref_id));
		$di_id = $Di->di_id;
		
		//array of ids of di_user who can handel particular student
		$getStudentDiUsers = self::getStudentDiUsers($user_id,$di_id);
		
		/*******
		 * STEP 1
		 * FIND ENTERY IN di_user_eoi and di_user_eoi
		 * FIND All enteries related to department and di_user of that university
		 * if found update eoi_status = accept
		 */
		 $criteria = new CDbCriteria;
		 $criteria->condition = "user_ref_id=".$user_id.' AND eoi_type="Criteria"';
		 // Give only di_user who have related to students preffered department
		 $criteria->addInCondition('di_user_ref_id', $getStudentDiUsers);
		 $res = DiUserEoi::model()->findAll($criteria);
		 
		$eoi_ids = CHtml::listData($res,'di_user_eoi_id','di_user_eoi_id');
		$eoi_ids = implode(',',$eoi_ids);
		
		$eoiUpdated = 0;
		if(count($res)>0){
			$eoiUpdated = DiUserEoi::model()->updateAll(
				array('eoi_status'=>$applyStatus),
				'di_user_eoi_id IN('.$eoi_ids.')'
			);
		}
		
		/*******
		 * STEP 2
		 * FIND ENTERY IN di_user_eoi_log
		 * FIND All enteries related to department and di_user of that university
		 * if found update eoi_status = accept
		 */
		 $criteria = new CDbCriteria;
		 $criteria->condition = "user_ref_id=".$user_id.' AND eoi_status!="Hotlead"';
		 // Give only di_user who have related to students preffered department
		 $criteria->addInCondition('di_user_ref_id', $getStudentDiUsers);
		 $res = DiUserEoiLog::model()->findAll($criteria);
		 
		$eoi_log_ids = CHtml::listData($res,'di_user_eoi_log_id','di_user_eoi_log_id');
		$eoi_log_ids = implode(',',$eoi_log_ids);
		
		$eoiLogUpdated = 0;
		if(count($res)>0){
			$eoiUpdated = DiUserEoiLog::model()->updateAll(
				array('eoi_status'=>$applyStatus),
				'di_user_eoi_log_id IN('.$eoi_log_ids.')'
			);
		}
		
		if( ($eoiUpdated > 0) || ($eoiLogUpdated>0) ){
			return true;
		} else{
		
			// if not found in eoi and eoi_log tables
			// then check entery in criteria_match, if found remove it
			Yii::import('application.modules.alertmatch.models.DiUserCriteriaMatch');
			Yii::import('application.modules.alertmatch.models.DiUserCriteria');
			
			$criteria = new CDbCriteria;
			$criteria->with = array('diUserCriteriaRef');
			$criteria->condition = "user_ref_id=".$user_id.'';
			$criteria->addInCondition('diUserCriteriaRef.di_user_ref_id', $getStudentDiUsers);

			//echo "<pre>";
			//print_r($criteria);
			$res = DiUserCriteriaMatch::model()->findAll($criteria);
			$di_user_criteria_match_ids = CHtml::listData($res,'di_user_criteria_match_id','di_user_criteria_match_id');
			$di_user_criteria_match_ids = implode(',',$di_user_criteria_match_ids);
	
			if(count($res)>0){
				$criteriaMatchDeleted = DiUserCriteriaMatch::model()->deleteAll(
				'di_user_criteria_match_id IN('.$di_user_criteria_match_ids.')'
				);
			}	
			
			// Return false indicated that now lead is not in alertmatch criteria match, if it was then we deleted
			// so it will be handeled in hotlead
			return false; 
				
		}
	}
	
	
	/* getStudentDiUsers($user_id,$di_id)
	*  input student_id as as user_id
	*  input $di_id, it will be unique id for particular university
	*  function will relate common departments between student and di_users for particular university
	*  return array of ids of di_user who can handel particular student ( who have related departments with students)
	*/
	
	static function getStudentDiUsers($user_id,$di_id){ // Get student id and University Di id
	
		$sql ="
			SELECT DISTINCT DU.di_user_id 
			FROM di_user AS DU, di_user_department AS DUD, student_preferred_department AS SPD
			WHERE
			DU.di_ref_id = ".$di_id." AND
			DUD.di_user_ref_id=DU.di_user_id AND
			DUD.main_department_ref_id = SPD.main_dept_ref_id AND
			SPD.user_ref_id = ".$user_id."
			";
		
        $connection  = Yii::app()->db;
        $command     = $connection->createCommand($sql);
        $rowCount    = $command->execute(); // execute the non-query SQL
 		
		$diUsersArr = array();
        if($rowCount>0){
            $data = $command->query();
			foreach($data as $data){
				$diUsersArr[] = $data['di_user_id'];
			}
		}	
		return $diUsersArr;
	}
	
	
		
   
}
