<?php

class StudentData extends CFormModel
{

    public $country_pref1;
    public $country_pref2;

    public $dept_pref1;
    public $dept_pref2;
    public $sub_dept_pref1;
    public $sub_dept_pref2;
    public $other_sub_dept_pref2;
    public $other_sub_dept_pref1;

    public $phone_number;
    public $country_code;
    public $username;
    public $email_prev;
    public $mark_primary;

    public $citizenship1;
    public $citizenship2;

    public $board;

    public function rules()
    {
        return array(
            array('country_pref1', 'validateOptions', 'on' => 'preferences, citizenship'),
            //array('citizenship1', 'validateCitizenShip', 'on' => 'citizenship'),
            array('phone_number', 'validateAlertOptions', 'on' => 'alerts'),
            array('username', 'match', 'pattern' => '/^[ a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'alerts'),
            //array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>Please enter different email address. <a href="'.Yii::app()->createUrl('login').'">Sign In</a></p></div>', 'on' => 'alerts'),
            array('country_code', 'required', 'on' => 'alerts', 'message'=>"<div class='holder'><p>Select {attribute}</p></div>"),
            array('phone_number, username', 'required', 'on' => 'alerts', 'message'=>"<div class='holder'><p>Enter your {attribute}</p></div>"),
            array('phone_number', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Phone should be atleast 7 numbers.</p></div>', 'tooLong' => '<div class="holder"><p>Phone number cannot be more than 12 digits.</p></div>', 'on' => 'alerts'),
            array('phone_number', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Should contain numbers only</p></div>', 'on' => 'alerts'),
            array('country_pref1, country_pref2,dept_pref1,dept_pref2,sub_dept_pref1,sub_dept_pref2,other_sub_dept_pref1,other_sub_dept_pref2, board, mark_primary, email_prev, citizenship1, citizenship2', 'safe'),
        );
    }

    public function attributeLabels()
    {
        return array(
            'country_pref1' => 'Country preference',
            'country_pref2' => 'Country preference',
            'dept_pref1' => 'Major preference',
            'dept_pref2' => 'Major preference',
            'sub_dept_pref1' => 'Department preference',
            'sub_dept_pref2' => 'Department preference',
            'other_sub_dept_pref1' => 'Department preference',
            'other_sub_dept_pref2' => 'Department preference',
            'phone_number' => 'phone number',
            'country_code' => 'country code',
            'username' => 'Email',
            'citizenship1'=>'Citizenship',
            'citizenship2'=>'Citizenship',
        );
    }

    public function validateOptions() {
        if (!$this->country_pref1 && !$this->country_pref2) {
            $this->addError('country_pref1', '<div class="holder"><p>Select a country of your preference</p></div>');
        }

        if (!$this->dept_pref1 && !$this->dept_pref2) {
            $this->addError('dept_pref1', '<div class="holder"><p>Select a major of interest</p></div>');
        }

        if ($this->dept_pref1 == $this->dept_pref2) {
            if ($this->sub_dept_pref1 && !$this->sub_dept_pref2) {
                $this->addError('sub_dept_pref2', '<div class="holder"><p>Select a department</p></div>');
            } elseif (!$this->sub_dept_pref1 && $this->sub_dept_pref2) {
                $this->addError('sub_dept_pref1', '<div class="holder"><p>Select a department</p></div>');
            }
        }

        if (($this->sub_dept_pref1 == 'others') && ($this->other_sub_dept_pref1 == '')) {
            $this->addError('other_sub_dept_pref1', '<div class="holder"><p>Enter course name you are looking for</p></div>');
        }

        if (($this->sub_dept_pref2 == 'others') && ($this->other_sub_dept_pref2 == '')) {
            $this->addError('other_sub_dept_pref2', '<div class="holder"><p>Enter course name you are looking for</p></div>');
        }
    }

    public function validateCitizenShip() {
        if (!$this->citizenship1 && !$this->country_pref2) {
            $this->addError('citizenship1', '<div class="holder"><p>Select your citizenship</p></div>');
        }
    }

    public function validateAlertOptions() {
        if ($this->country_code == 91) {/*
            $res = file_get_contents('http://www.bmobile.in/'.$this->phone_number);

            $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
            $res_arr1 = explode('</tbdy>', $res_arr[1]);

            $count = 0;
            $count = substr_count($res_arr1[0], $this->phone_number); */
            if ($this->phone_number[0] > 6) {

            } else {
                $this->addError('phone_number', '<div class="holder"><p>Enter a valid phone number</p></div>');
            }
        }

        if ($this->username != $this->email_prev) {
            $result = Yii::app()->db->createCommand()
                ->select('login_id')
                ->from('login_master')
                ->where('username="'.$this->username.'"')
                ->queryAll();
            if (count($result) > 0) {
                $this->addError('username', '<div class="holder"><p>This email address already exists</p></div>');
            }
        }

    }

}

?>