<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorExpertiseDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_expertise_department".
 *
 * The followings are the available columns in table 'vendor_expertise_department':
 * @property string $vendor_expertise_department_id
 * @property integer $vendor_contact_ref_id
 * @property integer $main_dept_ref_id
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property VendorContact $vendorContactRef
 */
class BaseVendorExpertiseDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorExpertiseDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_expertise_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_contact_ref_id, main_dept_ref_id', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_expertise_department_id, vendor_contact_ref_id, main_dept_ref_id, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorContactRef' => array(self::BELONGS_TO, 'VendorContact', 'vendor_contact_ref_id'),
                        'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id') 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_expertise_department_id' => 'Vendor Expertise Department',
			'vendor_contact_ref_id' => 'Vendor Contact Ref',
			'main_dept_ref_id' => 'Main Dept Ref',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_expertise_department_id',$this->vendor_expertise_department_id,true);
		$criteria->compare('vendor_contact_ref_id',$this->vendor_contact_ref_id);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}