<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreFacultyTests is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_faculty_tests".
 *
 * The followings are the available columns in table 'vendor_centre_faculty_tests':
 * @property integer $vendor_centre_faculty_test_id
 * @property integer $vendor_centre_faculty_ref_id
 * @property integer $entrance_ref_id
 *
 * The followings are the available model relations:
 * @property VendorCentreFaculty $vendorCentreFacultyRef
 * @property EntranceExam $entranceRef
 */
class BaseVendorCentreFacultyTests extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreFacultyTests the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_faculty_tests';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_centre_faculty_ref_id, entrance_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_faculty_test_id, vendor_centre_faculty_ref_id, entrance_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreFacultyRef' => array(self::BELONGS_TO, 'VendorCentreFaculty', 'vendor_centre_faculty_ref_id'),
			'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_faculty_test_id' => 'Vendor Centre Faculty Test',
			'vendor_centre_faculty_ref_id' => 'Vendor Centre Faculty Ref',
			'entrance_ref_id' => 'Entrance Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_faculty_test_id',$this->vendor_centre_faculty_test_id);
		$criteria->compare('vendor_centre_faculty_ref_id',$this->vendor_centre_faculty_ref_id);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}