<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCashback is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_cashback".
 *
 * The followings are the available columns in table 'vendor_cashback':
 * @property string $vendor_cashback_id
 * @property string $user_ref_id
 * @property string $vendor_centre_course_ref_id
 * @property string $registration_no
 * @property string $fees_paid
 * @property string $registration_date
 * @property string $receipt_path
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property VendorCentreCourse $vendorCentreCourseRef
 */
class BaseVendorCashback extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCashback the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_cashback';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, vendor_centre_course_ref_id, fees_paid', 'length', 'max'=>10),
			array('registration_no', 'length', 'max'=>50),
			array('receipt_path', 'length', 'max'=>255),
			array('registration_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_cashback_id, user_ref_id, vendor_centre_course_ref_id, registration_no, fees_paid, registration_date, receipt_path', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'vendorCentreCourseRef' => array(self::BELONGS_TO, 'VendorCentreCourse', 'vendor_centre_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_cashback_id' => 'Vendor Cashback',
			'user_ref_id' => 'User Ref',
			'vendor_centre_course_ref_id' => 'Vendor Centre Course Ref',
			'registration_no' => 'Registration No',
			'fees_paid' => 'Fees Paid',
			'registration_date' => 'Registration Date',
			'receipt_path' => 'Receipt Path',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_cashback_id',$this->vendor_cashback_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('vendor_centre_course_ref_id',$this->vendor_centre_course_ref_id,true);
		$criteria->compare('registration_no',$this->registration_no,true);
		$criteria->compare('fees_paid',$this->fees_paid,true);
		$criteria->compare('registration_date',$this->registration_date,true);
		$criteria->compare('receipt_path',$this->receipt_path,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}