<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorBannerRequestCallback is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_banner_request_callback".
 *
 * The followings are the available columns in table 'vendor_banner_request_callback':
 * @property string $vendor_banner_request_callback_id
 * @property integer $bs_ref_id
 * @property string $vendor_request_callback_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiBannerCampaignAdData $bsRef
 * @property VendorRequestCallback $vendorRequestCallbackRef
 */
class BaseVendorBannerRequestCallback extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorBannerRequestCallback the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_banner_request_callback';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bs_ref_id', 'numerical', 'integerOnly'=>true),
			array('vendor_request_callback_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_banner_request_callback_id, bs_ref_id, vendor_request_callback_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'bsRef' => array(self::BELONGS_TO, 'DiBannerCampaignAdData', 'bs_ref_id'),
			'vendorRequestCallbackRef' => array(self::BELONGS_TO, 'VendorRequestCallback', 'vendor_request_callback_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_banner_request_callback_id' => 'Vendor Banner Request Callback',
			'bs_ref_id' => 'Bs Ref',
			'vendor_request_callback_ref_id' => 'Vendor Request Callback Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_banner_request_callback_id',$this->vendor_banner_request_callback_id,true);
		$criteria->compare('bs_ref_id',$this->bs_ref_id);
		$criteria->compare('vendor_request_callback_ref_id',$this->vendor_request_callback_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}