<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendor is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor".
 *
 * The followings are the available columns in table 'vendor':
 * @property integer $vendor_id
 * @property string $vendor_type
 * @property string $name
 * @property string $logo
 * @property integer $established_year
 * @property string $about
 * @property string $website
 * @property string $center_image
 * @property integer $is_active
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property DiBannerCampaign[] $diBannerCampaigns
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property VendorAttachment[] $vendorAttachments
 * @property VendorCentre[] $vendorCentres
 * @property VendorContact[] $vendorContacts
 * @property VendorExpertAwards[] $vendorExpertAwards
 * @property VendorExpertCertification[] $vendorExpertCertifications
 * @property VendorExpertCommunication[] $vendorExpertCommunications
 * @property VendorExpertInfo[] $vendorExpertInfos
 * @property VendorExpertQualification[] $vendorExpertQualifications
 * @property VendorExpertiseCountry[] $vendorExpertiseCountries
 * @property VendorExpertiseDepartment[] $vendorExpertiseDepartments
 * @property VendorExpertiseTest[] $vendorExpertiseTests
 * @property VendorExpertiseUniversity[] $vendorExpertiseUniversities
 */
class BaseVendor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Vendor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, added_on', 'required'),
			array('established_year, is_active', 'numerical', 'integerOnly'=>true),
			array('vendor_type', 'length', 'max'=>16),
			array('name, logo, website', 'length', 'max'=>255),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('about, center_image, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_id, vendor_type, name, logo, established_year, about, website, center_image, is_active, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diBannerCampaigns' => array(self::HAS_MANY, 'DiBannerCampaign', 'vendor_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorAttachments' => array(self::HAS_MANY, 'VendorAttachment', 'vendor_ref_id'),
			'vendorCentres' => array(self::HAS_MANY, 'VendorCentre', 'vendor_ref_id'),
			'vendorContacts' => array(self::HAS_MANY, 'VendorContact', 'vendor_ref_id'),
			'vendorExpertAwards' => array(self::HAS_MANY, 'VendorExpertAwards', 'vendor_ref_id'),
			'vendorExpertCertifications' => array(self::HAS_MANY, 'VendorExpertCertification', 'vendor_ref_id'),
			'vendorExpertCommunication' => array(self::HAS_ONE, 'VendorExpertCommunication', 'vendor_ref_id'),
			'vendorExpertInfo' => array(self::HAS_ONE, 'VendorExpertInfo', 'vendor_ref_id'),
			'vendorExpertQualifications' => array(self::HAS_MANY, 'VendorExpertQualification', 'vendor_ref_id'),
			'vendorExpertiseCountries' => array(self::HAS_MANY, 'VendorExpertiseCountry', 'vendor_ref_id'),
			'vendorExpertiseDepartments' => array(self::HAS_MANY, 'VendorExpertiseDepartment', 'vendor_ref_id'),
			'vendorExpertiseTests' => array(self::HAS_MANY, 'VendorExpertiseTest', 'vendor_ref_id'),
			'vendorExpertiseUniversities' => array(self::HAS_MANY, 'VendorExpertiseUniversity', 'vendor_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_id' => 'Vendor',
			'vendor_type' => 'Vendor Type',
			'name' => 'Name',
			'logo' => 'Logo',
			'established_year' => 'Established Year',
			'about' => 'About',
			'website' => 'Website',
			'center_image' => 'Center Image',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_id',$this->vendor_id);
		$criteria->compare('vendor_type',$this->vendor_type,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('logo',$this->logo,true);
		$criteria->compare('established_year',$this->established_year);
		$criteria->compare('about',$this->about,true);
		$criteria->compare('website',$this->website,true);
		$criteria->compare('center_image',$this->center_image,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}