<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserMilestoneTracking is autogenerate by UniModel generator
 *
 * This is the model class for table "user_milestone_tracking".
 *
 * The followings are the available columns in table 'user_milestone_tracking':
 * @property string $user_milestone_tracking_id
 * @property string $user_ref_id
 * @property integer $milestone_ref_id
 * @property string $deadline_date
 * @property string $completion_date
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupMilestone $milestoneRef
 * @property TblUserMaster $userRef
 */
class BaseUserMilestoneTracking extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserMilestoneTracking the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_milestone_tracking';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('milestone_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('deadline_date, completion_date, added_on,is_migrated', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_milestone_tracking_id, user_ref_id, milestone_ref_id, deadline_date, completion_date, added_on,is_migrated, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'milestoneRef' => array(self::BELONGS_TO, 'LookupMilestone', 'milestone_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_milestone_tracking_id' => 'User Milestone Tracking',
			'user_ref_id' => 'User Ref',
			'milestone_ref_id' => 'Milestone Ref',
			'deadline_date' => 'Deadline Date',
			'completion_date' => 'Completion Date',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_milestone_tracking_id',$this->user_milestone_tracking_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('milestone_ref_id',$this->milestone_ref_id);
		$criteria->compare('deadline_date',$this->deadline_date,true);
		$criteria->compare('completion_date',$this->completion_date,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}