<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityInsights is autogenerate by UniModel generator
 *
 * This is the model class for table "university_insights".
 *
 * The followings are the available columns in table 'university_insights':
 * @property integer $insight_id
 * @property integer $uni_ref_id
 * @property string $uni_insight
 * @property string $counsellor_insight
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversityInsights extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityInsights the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_insights';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('uni_insight, counsellor_insight', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('insight_id, uni_ref_id, uni_insight, counsellor_insight', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'insight_id' => 'Insight',
			'uni_ref_id' => 'Uni Ref',
			'uni_insight' => 'Uni Insight',
			'counsellor_insight' => 'Counsellor Insight',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('insight_id',$this->insight_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_insight',$this->uni_insight,true);
		$criteria->compare('counsellor_insight',$this->counsellor_insight,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}