<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityDepartmentEntranceExamModuleCutoff is autogenerate by UniModel generator
 *
 * This is the model class for table "university_department_entrance_exam_module_cutoff".
 *
 * The followings are the available columns in table 'university_department_entrance_exam_module_cutoff':
 * @property string $university_department_entrance_exam_module_cutoff_id
 * @property integer $uni_ref_id
 * @property integer $entrance_exam_module_department_ref_id
 * @property integer $weightage
 * @property integer $min_cutoff
 * @property integer $low_range
 * @property integer $upper_range
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 * @property EntranceExamModuleDepartment $entranceExamModuleDepartmentRef
 */
class BaseUniversityDepartmentEntranceExamModuleCutoff extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityDepartmentEntranceExamModuleCutoff the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_department_entrance_exam_module_cutoff';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, entrance_exam_module_department_ref_id, weightage, min_cutoff, low_range, upper_range', 'required'),
			array('uni_ref_id, entrance_exam_module_department_ref_id, weightage, min_cutoff, low_range, upper_range', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_department_entrance_exam_module_cutoff_id, uni_ref_id, entrance_exam_module_department_ref_id, weightage, min_cutoff, low_range, upper_range', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'entranceExamModuleDepartmentRef' => array(self::BELONGS_TO, 'EntranceExamModuleDepartment', 'entrance_exam_module_department_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_department_entrance_exam_module_cutoff_id' => 'University Department Entrance Exam Module Cutoff',
			'uni_ref_id' => 'Uni Ref',
			'entrance_exam_module_department_ref_id' => 'Entrance Exam Module Department Ref',
			'weightage' => 'Weightage',
			'min_cutoff' => 'Min Cutoff',
			'low_range' => 'Low Range',
			'upper_range' => 'Upper Range',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_department_entrance_exam_module_cutoff_id',$this->university_department_entrance_exam_module_cutoff_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('entrance_exam_module_department_ref_id',$this->entrance_exam_module_department_ref_id);
		$criteria->compare('weightage',$this->weightage);
		$criteria->compare('min_cutoff',$this->min_cutoff);
		$criteria->compare('low_range',$this->low_range);
		$criteria->compare('upper_range',$this->upper_range);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}