<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUnivarietyContactus is autogenerate by UniModel generator
 *
 * This is the model class for table "univariety_contactus".
 *
 * The followings are the available columns in table 'univariety_contactus':
 * @property string $univariety_contactus_id
 * @property string $contact_name
 * @property string $email
 * @property string $contact_number
 * @property string $contact_source
 * @property string $contact_comment
 * @property string $additional_info
 * @property string $added_on
 * @property string $bas_city_name
 * @property string $bas_class
 * @property string $bas_session
 */
class BaseUnivarietyContactus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UnivarietyContactus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'univariety_contactus';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('contact_name, email', 'required'),
			array('contact_name, email, additional_info, bas_city_name', 'length', 'max'=>100),
			array('contact_number', 'length', 'max'=>20),
			array('contact_source', 'length', 'max'=>10),
			array('bas_class, bas_session', 'length', 'max'=>2),
			array('contact_comment, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('univariety_contactus_id, contact_name, email, contact_number, contact_source, contact_comment, additional_info, added_on, bas_city_name, bas_class, bas_session', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'univariety_contactus_id' => 'Univariety Contactus',
			'contact_name' => 'Contact Name',
			'email' => 'Email',
			'contact_number' => 'Contact Number',
			'contact_source' => 'Contact Source',
			'contact_comment' => 'Contact Comment',
			'additional_info' => 'Additional Info',
			'added_on' => 'Added On',
			'bas_city_name' => 'Bas City Name',
			'bas_class' => 'Bas Class',
			'bas_session' => 'Bas Session',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('univariety_contactus_id',$this->univariety_contactus_id,true);
		$criteria->compare('contact_name',$this->contact_name,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('contact_source',$this->contact_source,true);
		$criteria->compare('contact_comment',$this->contact_comment,true);
		$criteria->compare('additional_info',$this->additional_info,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('bas_city_name',$this->bas_city_name,true);
		$criteria->compare('bas_class',$this->bas_class,true);
		$criteria->compare('bas_session',$this->bas_session,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}