<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniCourseTest is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_course_test".
 *
 * The followings are the available columns in table 'uni_course_test':
 * @property string $uni_course_test_id
 * @property integer $uni_ref_id
 * @property string $uni_course_ref_id
 * @property integer $entrance_ref_id
 * @property string $test_needed
 * @property string $test_date
 * @property string $result_date
 * @property string $cutoff_numbers
 * @property string $test_prep_comments
 * @property string $site_for_prep
 * @property string $time_for_prep
 * @property string $test_comments
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property LookupEntrance $entranceRef
 * @property TblAdmin $modifiedBy
 */
class BaseUniCourseTest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniCourseTest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_course_test';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, uni_course_ref_id', 'required'),
			array('uni_ref_id, entrance_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('uni_course_ref_id', 'length', 'max'=>11),
			array('cutoff_numbers', 'length', 'max'=>10),
			array('test_prep_comments, site_for_prep, time_for_prep', 'length', 'max'=>255),
			array('test_needed, test_date, result_date, test_comments, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uni_course_test_id, uni_ref_id, uni_course_ref_id, entrance_ref_id, test_needed, test_date, result_date, cutoff_numbers, test_prep_comments, site_for_prep, time_for_prep, test_comments, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			//'entranceRef' => array(self::BELONGS_TO, 'LookupEntrance', 'entrance_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_course_test_id' => 'Uni Course Test',
			'uni_ref_id' => 'Uni Ref',
			'uni_course_ref_id' => 'Uni Course Ref',
			'entrance_ref_id' => 'Entrance Ref',
			'test_needed' => 'Test Needed',
			'test_date' => 'Test Date',
			'result_date' => 'Result Date',
			'cutoff_numbers' => 'Cutoff Numbers',
			'test_prep_comments' => 'Test Prep Comments',
			'site_for_prep' => 'Site For Prep',
			'time_for_prep' => 'Time For Prep',
			'test_comments' => 'Test Comments',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_course_test_id',$this->uni_course_test_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('test_needed',$this->test_needed,true);
		$criteria->compare('test_date',$this->test_date,true);
		$criteria->compare('result_date',$this->result_date,true);
		$criteria->compare('cutoff_numbers',$this->cutoff_numbers,true);
		$criteria->compare('test_prep_comments',$this->test_prep_comments,true);
		$criteria->compare('site_for_prep',$this->site_for_prep,true);
		$criteria->compare('time_for_prep',$this->time_for_prep,true);
		$criteria->compare('test_comments',$this->test_comments,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}