<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblEmailEvents is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_email_events".
 *
 * The followings are the available columns in table 'tbl_email_events':
 * @property string $tbl_email_events_id
 * @property integer $event_ref_id
 * @property string $tbl_event_email_ref_id
 * @property string $tracking_key
 *
 * The followings are the available model relations:
 * @property TblEvent $eventRef
 * @property TblEventEmail $tblEventEmailRef
 */
class BaseTblEmailEvents extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblEmailEvents the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_email_events';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id', 'numerical', 'integerOnly'=>true),
			array('tbl_event_email_ref_id', 'length', 'max'=>10),
			array('tracking_key', 'length', 'max'=>36),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_email_events_id, event_ref_id, tbl_event_email_ref_id, tracking_key', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'TblEvent', 'event_ref_id'),
			'tblEventEmailRef' => array(self::BELONGS_TO, 'TblEventEmail', 'tbl_event_email_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_email_events_id' => 'Tbl Email Events',
			'event_ref_id' => 'Event Ref',
			'tbl_event_email_ref_id' => 'Tbl Event Email Ref',
			'tracking_key' => 'Tracking Key',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_email_events_id',$this->tbl_email_events_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('tbl_event_email_ref_id',$this->tbl_event_email_ref_id,true);
		$criteria->compare('tracking_key',$this->tracking_key,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}