<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentOutplacementTests is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_tests".
 *
 * The followings are the available columns in table 'student_outplacement_tests':
 * @property string $student_outplacement_tests_id
 * @property string $user_ref_id
 * @property integer $entrance_ref_id
 * @property string $exam_name
 * @property integer $month
 * @property integer $year
 * @property integer $score
 * @property integer $score_subject_1
 * @property integer $score_subject_2
 * @property integer $score_subject_3
 * @property string $added_on
 * @property string $status
 * @property integer $score_subject_4
 * @property integer $rank
 * @property integer $percentile
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceRef
 * @property TblUserMaster $userRef
 * @property StudentOutplacementTestsMarks[] $studentOutplacementTestsMarks
 */
class BaseStudentOutplacementTests extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOutplacementTests the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_outplacement_tests';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, month, year, added_on, status', 'required'),
			array('entrance_ref_id, month, year, score, score_subject_1, score_subject_2, score_subject_3, score_subject_4, rank, percentile', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('exam_name', 'length', 'max'=>250),
			array('status', 'length', 'max'=>9),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_outplacement_tests_id, user_ref_id, entrance_ref_id, exam_name, month, year, score, score_subject_1, score_subject_2, score_subject_3, added_on, status, score_subject_4, rank, percentile', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'studentOutplacementTestsMarks' => array(self::HAS_MANY, 'StudentOutplacementTestsMarks', 'student_outplacement_tests_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_outplacement_tests_id' => 'Student Outplacement Tests',
			'user_ref_id' => 'User Ref',
			'entrance_ref_id' => 'Entrance Ref',
			'exam_name' => 'Exam Name',
			'month' => 'Month',
			'year' => 'Year',
			'score' => 'Score',
			'score_subject_1' => 'Score Subject 1',
			'score_subject_2' => 'Score Subject 2',
			'score_subject_3' => 'Score Subject 3',
			'added_on' => 'Added On',
			'status' => 'Status',
			'score_subject_4' => 'Score Subject 4',
			'rank' => 'Rank',
			'percentile' => 'Percentile',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_outplacement_tests_id',$this->student_outplacement_tests_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('exam_name',$this->exam_name,true);
		$criteria->compare('month',$this->month);
		$criteria->compare('year',$this->year);
		$criteria->compare('score',$this->score);
		$criteria->compare('score_subject_1',$this->score_subject_1);
		$criteria->compare('score_subject_2',$this->score_subject_2);
		$criteria->compare('score_subject_3',$this->score_subject_3);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('score_subject_4',$this->score_subject_4);
		$criteria->compare('rank',$this->rank);
		$criteria->compare('percentile',$this->percentile);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}