<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentCounsellingRequest is autogenerate by UniModel generator
 *
 * This is the model class for table "student_counselling_request".
 *
 * The followings are the available columns in table 'student_counselling_request':
 * @property string $request_id
 * @property string $student_ref_id
 * @property string $schedule_date
 * @property string $schedule_time
 * @property integer $entered_by
 * @property string $entered_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $enteredBy
 * @property TblUserMaster $studentRef
 */
class BaseStudentCounsellingRequest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentCounsellingRequest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_counselling_request';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_ref_id, schedule_date, schedule_time, entered_by, entered_on', 'required'),
			array('entered_by', 'numerical', 'integerOnly'=>true),
			array('student_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('request_id, student_ref_id, schedule_date, schedule_time, entered_by, entered_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'enteredBy' => array(self::BELONGS_TO, 'TblAdmin', 'entered_by'),
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'request_id' => 'Request',
			'student_ref_id' => 'Student Ref',
			'schedule_date' => 'Schedule Date',
			'schedule_time' => 'Schedule Time',
			'entered_by' => 'Entered By',
			'entered_on' => 'Entered On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('request_id',$this->request_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('schedule_date',$this->schedule_date,true);
		$criteria->compare('schedule_time',$this->schedule_time,true);
		$criteria->compare('entered_by',$this->entered_by);
		$criteria->compare('entered_on',$this->entered_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}