<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipAge is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_age".
 *
 * The followings are the available columns in table 'scholarship_age':
 * @property integer $scholarship_age_id
 * @property string $scholarship_ref_id
 * @property string $comparison_operator
 * @property integer $age
 * @property string $added_on
 * @property integer $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property Scholarship $scholarshipRef
 */
class BaseScholarshipAge extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipAge the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_age';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, added_by', 'required'),
			array('age, added_by', 'numerical', 'integerOnly'=>true),
			array('scholarship_ref_id', 'length', 'max'=>10),
			array('comparison_operator', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_age_id, scholarship_ref_id, comparison_operator, age, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_age_id' => 'Scholarship Age',
			'scholarship_ref_id' => 'Scholarship Ref',
			'comparison_operator' => 'Comparison Operator',
			'age' => 'Age',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_age_id',$this->scholarship_age_id);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('comparison_operator',$this->comparison_operator,true);
		$criteria->compare('age',$this->age);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}