<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProspectPartners is autogenerate by UniModel generator
 *
 * This is the model class for table "prospect_partners".
 *
 * The followings are the available columns in table 'prospect_partners':
 * @property string $prospect_partners_id
 * @property integer $external_advisor_ref_id
 * @property integer $city_ref_id
 * @property integer $vendor_ref_id
 * @property string $added_on
 * @property string $prospect_interaction_ref_id
 *
 * The followings are the available model relations:
 * @property ProspectInteraction $prospectInteractionRef
 * @property TblCityMaster $cityRef
 * @property TblAdmin $externalAdvisorRef
 * @property Vendor $vendorRef
 */
class BaseProspectPartners extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProspectPartners the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'prospect_partners';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('external_advisor_ref_id, city_ref_id, vendor_ref_id', 'numerical', 'integerOnly'=>true),
			array('prospect_interaction_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('prospect_partners_id, external_advisor_ref_id, city_ref_id, vendor_ref_id, added_on, prospect_interaction_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'prospectInteractionRef' => array(self::BELONGS_TO, 'ProspectInteraction', 'prospect_interaction_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'externalAdvisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'external_advisor_ref_id'),
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'prospect_partners_id' => 'Prospect Partners',
			'external_advisor_ref_id' => 'External Advisor Ref',
			'city_ref_id' => 'City Ref',
			'vendor_ref_id' => 'Vendor Ref',
			'added_on' => 'Added On',
			'prospect_interaction_ref_id' => 'Prospect Interaction Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('prospect_partners_id',$this->prospect_partners_id,true);
		$criteria->compare('external_advisor_ref_id',$this->external_advisor_ref_id);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('prospect_interaction_ref_id',$this->prospect_interaction_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}