<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupSummerPlan is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_summer_plan".
 *
 * The followings are the available columns in table 'lookup_summer_plan':
 * @property integer $summer_plan_id
 * @property string $summer_plan
 * @property string $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property StudentSummerPlan[] $studentSummerPlans
 */
class BaseLookupSummerPlan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupSummerPlan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_summer_plan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('summer_plan', 'length', 'max'=>100),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('summer_plan_id, summer_plan, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentSummerPlans' => array(self::HAS_MANY, 'StudentSummerPlan', 'summer_plan_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'summer_plan_id' => 'Summer Plan',
			'summer_plan' => 'Summer Plan',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('summer_plan_id',$this->summer_plan_id);
		$criteria->compare('summer_plan',$this->summer_plan,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}