<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupReasonStudyAbroad is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_reason_study_abroad".
 *
 * The followings are the available columns in table 'lookup_reason_study_abroad':
 * @property integer $reason_study_abroad_id
 * @property string $reason
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster[] $tblUserMasters
 */
class BaseLookupReasonStudyAbroad extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupReasonStudyAbroad the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_reason_study_abroad';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reason, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('reason', 'length', 'max'=>75),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('reason_study_abroad_id, reason, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'reason_study_abroad_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'reason_study_abroad_id' => 'Reason Study Abroad',
			'reason' => 'Reason',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('reason_study_abroad_id',$this->reason_study_abroad_id);
		$criteria->compare('reason',$this->reason,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}