<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupProduct is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_product".
 *
 * The followings are the available columns in table 'lookup_product':
 * @property integer $product_id
 * @property string $product_shortcode
 * @property string $product_description
 * @property double $unit_cost
 * @property integer $user_type_ref_id
 * @property string $begin_date
 * @property string $end_date
 * @property integer $is_active
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiProduct[] $diProducts
 * @property DiProductCredit[] $diProductCredits
 * @property DiProductDebit[] $diProductDebits
 * @property LookupUserType $userTypeRef
 * @property OrderItem[] $orderItems
 */
class BaseLookupProduct extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupProduct the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_product';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_shortcode, unit_cost, begin_date, is_active, added_by', 'required'),
			array('user_type_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('unit_cost', 'numerical'),
			array('product_shortcode', 'length', 'max'=>45),
			array('product_description', 'length', 'max'=>255),
			array('added_by', 'length', 'max'=>10),
			array('end_date, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('product_id, product_shortcode, product_description, unit_cost, user_type_ref_id, begin_date, end_date, is_active, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diProducts' => array(self::HAS_MANY, 'DiProduct', 'product_ref_id'),
			'diProductCredits' => array(self::HAS_MANY, 'DiProductCredit', 'product_ref_id'),
			'diProductDebits' => array(self::HAS_MANY, 'DiProductDebit', 'product_ref_id'),
			'userTypeRef' => array(self::BELONGS_TO, 'LookupUserType', 'user_type_ref_id'),
			'orderItems' => array(self::HAS_MANY, 'OrderItem', 'product_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'product_id' => 'Product',
			'product_shortcode' => 'Product Shortcode',
			'product_description' => 'Product Description',
			'unit_cost' => 'Unit Cost',
			'user_type_ref_id' => 'User Type Ref',
			'begin_date' => 'Begin Date',
			'end_date' => 'End Date',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_shortcode',$this->product_shortcode,true);
		$criteria->compare('product_description',$this->product_description,true);
		$criteria->compare('unit_cost',$this->unit_cost);
		$criteria->compare('user_type_ref_id',$this->user_type_ref_id);
		$criteria->compare('begin_date',$this->begin_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}