<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseGemLead is autogenerate by UniModel generator
 *
 * This is the model class for table "gem_lead".
 *
 * The followings are the available columns in table 'gem_lead':
 * @property string $gem_lead_id
 * @property string $name
 * @property string $email_id
 * @property string $phone_number
 * @property string $date_time_to_call
 * @property string $reference_name
 * @property string $reference_email
 * @property string $referer_number
 * @property string $referer_comments
 * @property string $added_on
 * @property string $gem_status
 *
 * The followings are the available model relations:
 * @property GemLeadProspect[] $gemLeadProspects
 */
class BaseGemLead extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GemLead the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gem_lead';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, phone_number, referer_comments, added_on', 'required'),
			array('name, reference_name', 'length', 'max'=>50),
			array('email_id, reference_email', 'length', 'max'=>100),
			array('phone_number, gem_status', 'length', 'max'=>15),
			array('referer_number', 'length', 'max'=>20),
			array('referer_comments', 'length', 'max'=>255),
			array('date_time_to_call', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('gem_lead_id, name, email_id, phone_number, date_time_to_call, reference_name, reference_email, referer_number, referer_comments, added_on, gem_status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'gemLeadProspects' => array(self::HAS_ONE, 'GemLeadProspect', 'gem_lead_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'gem_lead_id' => 'Gem Lead',
			'name' => 'Name',
			'email_id' => 'Email',
			'phone_number' => 'Phone Number',
			'date_time_to_call' => 'Date Time To Call',
			'reference_name' => 'Reference Name',
			'reference_email' => 'Reference Email',
			'referer_number' => 'Referer Number',
			'referer_comments' => 'Referer Comments',
			'added_on' => 'Added On',
			'gem_status' => 'Gem Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('gem_lead_id',$this->gem_lead_id,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('phone_number',$this->phone_number,true);
		$criteria->compare('date_time_to_call',$this->date_time_to_call,true);
		$criteria->compare('reference_name',$this->reference_name,true);
		$criteria->compare('reference_email',$this->reference_email,true);
		$criteria->compare('referer_number',$this->referer_number,true);
		$criteria->compare('referer_comments',$this->referer_comments,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('gem_status',$this->gem_status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}