<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEventTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "event_tracker".
 *
 * The followings are the available columns in table 'event_tracker':
 * @property string $event_tracker_id
 * @property integer $event_ref_id
 * @property string $user_ref_id
 * @property integer $invitation_number
 * @property string $user_status
 * @property string $sent_on
 * @property string $responded_on
 *
 * The followings are the available model relations:
 * @property Event $eventRef
 * @property TblUserMaster $userRef
 */
class BaseEventTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id, user_ref_id, invitation_number, sent_on', 'required'),
			array('event_ref_id, invitation_number', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('user_status', 'length', 'max'=>12),
			array('responded_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_tracker_id, event_ref_id, user_ref_id, invitation_number, user_status, sent_on, responded_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'Event', 'event_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_tracker_id' => 'Event Tracker',
			'event_ref_id' => 'Event Ref',
			'user_ref_id' => 'User Ref',
			'invitation_number' => 'Invitation Number',
			'user_status' => 'User Status',
			'sent_on' => 'Sent On',
			'responded_on' => 'Responded On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_tracker_id',$this->event_tracker_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('invitation_number',$this->invitation_number);
		$criteria->compare('user_status',$this->user_status,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('responded_on',$this->responded_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}