<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEvent is autogenerate by UniModel generator
 *
 * This is the model class for table "event".
 *
 * The followings are the available columns in table 'event':
 * @property integer $event_id
 * @property string $title
 * @property string $event_type
 * @property string $start_date
 * @property string $end_date
 * @property string $start_time
 * @property string $end_time
 * @property integer $timezone_ref_id
 * @property string $address1
 * @property string $address2
 * @property integer $city_ref_id
 * @property integer $country_ref_id
 * @property string $website
 * @property string $contact_number
 * @property string $event_summary
 * @property string $event_detail
 * @property integer $current_invitation_number
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblCityMaster $cityRef
 * @property TblCountryMaster $countryRef
 * @property LoginMaster $modifiedBy
 * @property LookupTimezone $timezoneRef
 * @property EventInvitation[] $eventInvitations
 * @property EventSpeaker[] $eventSpeakers
 * @property EventTracker[] $eventTrackers
 */
class BaseEvent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Event the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, start_date, end_date, start_time, timezone_ref_id, current_invitation_number, added_by, added_on', 'required'),
			array('timezone_ref_id, city_ref_id, country_ref_id, current_invitation_number', 'numerical', 'integerOnly'=>true),
			array('title, address1, address2, website', 'length', 'max'=>255),
			array('event_type', 'length', 'max'=>8),
			array('contact_number', 'length', 'max'=>20),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('end_time, event_summary, event_detail, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_id, title, event_type, start_date, end_date, start_time, end_time, timezone_ref_id, address1, address2, city_ref_id, country_ref_id, website, contact_number, event_summary, event_detail, current_invitation_number, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'timezoneRef' => array(self::BELONGS_TO, 'LookupTimezone', 'timezone_ref_id'),
			'eventInvitations' => array(self::HAS_MANY, 'EventInvitation', 'event_ref_id'),
			'eventSpeakers' => array(self::HAS_MANY, 'EventSpeaker', 'event_ref_id'),
			'eventTrackers' => array(self::HAS_MANY, 'EventTracker', 'event_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_id' => 'Event',
			'title' => 'Title',
			'event_type' => 'Event Type',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
			'timezone_ref_id' => 'Timezone Ref',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city_ref_id' => 'City Ref',
			'country_ref_id' => 'Country Ref',
			'website' => 'Website',
			'contact_number' => 'Contact Number',
			'event_summary' => 'Event Summary',
			'event_detail' => 'Event Detail',
			'current_invitation_number' => 'Current Invitation Number',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_id',$this->event_id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('event_type',$this->event_type,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);
		$criteria->compare('timezone_ref_id',$this->timezone_ref_id);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('website',$this->website,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('event_summary',$this->event_summary,true);
		$criteria->compare('event_detail',$this->event_detail,true);
		$criteria->compare('current_invitation_number',$this->current_invitation_number);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}