<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamModuleEntranceExam is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_module_entrance_exam".
 *
 * The followings are the available columns in table 'entrance_exam_module_entrance_exam':
 * @property string $entrance_exam_module_entrance_exam_id
 * @property integer $entrance_exam_ref_id
 * @property integer $entrance_exam_module_ref_id
 *
 * The followings are the available model relations:
 * @property EntranceExamModuleDepartment[] $entranceExamModuleDepartments
 * @property EntranceExam $entranceExamRef
 * @property EntranceExamModule $entranceExamModuleRef
 * @property UserEntranceExamModule[] $userEntranceExamModules
 */
class BaseEntranceExamModuleEntranceExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamModuleEntranceExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_module_entrance_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, entrance_exam_module_ref_id', 'required'),
			array('entrance_exam_ref_id, entrance_exam_module_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_module_entrance_exam_id, entrance_exam_ref_id, entrance_exam_module_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamModuleDepartments' => array(self::HAS_MANY, 'EntranceExamModuleDepartment', 'entrance_exam_module_entrance_exam_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'entranceExamModuleRef' => array(self::BELONGS_TO, 'EntranceExamModule', 'entrance_exam_module_ref_id'),
			'userEntranceExamModules' => array(self::HAS_MANY, 'UserEntranceExamModule', 'entrance_exam_module_entrance_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_module_entrance_exam_id' => 'Entrance Exam Module Entrance Exam',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'entrance_exam_module_ref_id' => 'Entrance Exam Module Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_module_entrance_exam_id',$this->entrance_exam_module_entrance_exam_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('entrance_exam_module_ref_id',$this->entrance_exam_module_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}