<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamDateSection is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_date_section".
 *
 * The followings are the available columns in table 'entrance_exam_date_section':
 * @property integer $entrance_exam_date_section_id
 * @property integer $entrance_exam_ref_id
 * @property string $section
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property EntranceExamDateLabel[] $entranceExamDateLabels
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property EntranceExam $entranceExamRef
 */
class BaseEntranceExamDateSection extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamDateSection the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_date_section';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, section, added_on', 'required'),
			array('entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('section', 'length', 'max'=>75),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_date_section_id, entrance_exam_ref_id, section, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamDateLabels' => array(self::HAS_MANY, 'EntranceExamDateLabel', 'entrance_exam_date_section_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_date_section_id' => 'Entrance Exam Date Section',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'section' => 'Section',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_date_section_id',$this->entrance_exam_date_section_id);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('section',$this->section,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}