<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExam is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam".
 *
 * The followings are the available columns in table 'entrance_exam':
 * @property integer $entrance_id
 * @property string $entrance_short_name
 * @property string $entrance_full_name
 * @property string $conducted_by
 * @property integer $exam_duration
 * @property string $exam_frequency
 * @property integer $students_appeared_last_year
 * @property integer $number_of_seats
 * @property string $type_of_exam
 * @property string $kind_of_exam
 * @property string $application_availability
 * @property string $application_fees
 * @property string $application_deadline
 * @property string $exam_date
 * @property integer $max_marks
 * @property string $eligibility
 * @property string $application_process
 * @property string $exam_brief
 * @property string $exam_description
 * @property string $preparation_strategy
 * @property string $fees_information
 * @property string $website
 * @property string $exam_pattern
 * @property string $preparation_time
 * @property string $coaching_required
 * @property string $coaching_required1
 * @property string $coaching_normal_time
 * @property string $coaching_stretch_time
 * @property string $application_url
 * @property string $validity
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property DepartmentEntranceExam[] $departmentEntranceExams
 * @property TblAdmin $addedBy
 * @property EntranceExamAlternate[] $entranceExamAlternates
 * @property EntranceExamAlternate[] $entranceExamAlternates1
 * @property EntranceExamApplicableDepartment[] $entranceExamApplicableDepartments
 * @property EntranceExamApplicableLocation[] $entranceExamApplicableLocations
 * @property EntranceExamCourseLevel[] $entranceExamCourseLevels
 * @property EntranceExamDate[] $entranceExamDates
 * @property EntranceExamFees[] $entranceExamFees
 * @property EntranceExamMode[] $entranceExamModes
 * @property EntranceExamModuleEntranceExam[] $entranceExamModuleEntranceExams
 * @property EntranceExamVendorBranch[] $entranceExamVendorBranches
 * @property StudentEntranceExamVendorBranch[] $studentEntranceExamVendorBranches
 * @property UniCourseTest[] $uniCourseTests
 */
class BaseEntranceExam extends CActiveRecord
{
    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return EntranceExam the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'entrance_exam';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('exam_duration, students_appeared_last_year, number_of_seats, max_marks, added_by, modified_by', 'numerical', 'integerOnly'=>true),
            array('entrance_short_name, kind_of_exam', 'length', 'max'=>50),
            array('entrance_full_name, website, preparation_time, application_url', 'length', 'max'=>255),
            array('conducted_by, application_availability, application_fees, application_deadline', 'length', 'max'=>100),
            array('exam_frequency', 'length', 'max'=>10),
            array('type_of_exam', 'length', 'max'=>13),
            array('category', 'length', 'max'=>25),
            array('exam_date, coaching_required, coaching_normal_time, coaching_stretch_time, validity', 'length', 'max'=>45),
            array('coaching_required1', 'length', 'max'=>6),
            array('is_international_serach', 'length', 'max'=>6),
            array('eligibility, application_process, exam_brief, exam_description, preparation_strategy, fees_information, exam_pattern, added_on, modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('entrance_id, entrance_short_name, entrance_full_name, conducted_by, exam_duration, exam_frequency, students_appeared_last_year, number_of_seats, type_of_exam, category ,kind_of_exam, application_availability, application_fees, application_deadline, exam_date, max_marks, eligibility, application_process, exam_brief, exam_description, preparation_strategy, fees_information, website, exam_pattern, preparation_time, coaching_required, coaching_required1, coaching_normal_time, coaching_stretch_time, application_url, validity, added_on, added_by, modified_on, modified_by, is_international_serach', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automaticallty generated below.
        return array(
            'departmentEntranceExams' => array(self::HAS_MANY, 'DepartmentEntranceExam', 'entrance_exam_ref_id'),
            'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
            'entranceExamAlternates' => array(self::HAS_MANY, 'EntranceExamAlternate', 'primary_entrance_exam_ref_id'),
            'entranceExamAlternates1' => array(self::HAS_MANY, 'EntranceExamAlternate', 'alternate_entrance_exam_ref_id'),
            'entranceExamApplicableDepartments' => array(self::HAS_MANY, 'EntranceExamApplicableDepartment', 'entrance_exam_ref_id'),
            'entranceExamApplicableLocations' => array(self::HAS_MANY, 'EntranceExamApplicableLocation', 'entrance_exam_ref_id'),
            'entranceExamCourseLevels' => array(self::HAS_MANY, 'EntranceExamCourseLevel', 'entrance_exam_ref_id'),
            'entranceExamDates' => array(self::HAS_MANY, 'EntranceExamDate', 'entrance_exam_ref_id'),
            'entranceExamFees' => array(self::HAS_MANY, 'EntranceExamFees', 'entrance_exam_ref_id'),
            'entranceExamModes' => array(self::HAS_MANY, 'EntranceExamMode', 'entrance_exam_ref_id'),
            'entranceExamModuleEntranceExams' => array(self::HAS_MANY, 'EntranceExamModuleEntranceExam', 'entrance_exam_ref_id'),
            'entranceExamVendorBranches' => array(self::HAS_MANY, 'EntranceExamVendorBranch', 'entrance_exam_ref_id'),
            'studentEntranceExamVendorBranches' => array(self::HAS_MANY, 'StudentEntranceExamVendorBranch', 'entrance_exam_ref_id'),
            'uniCourseTests' => array(self::HAS_MANY, 'UniCourseTest', 'entrance_ref_id'),
            'entranceExamCountries' => array(self::HAS_MANY,'EntranceExamCountry','entrance_exam_ref_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'entrance_id' => 'Entrance',
            'entrance_short_name' => 'Entrance Short Name',
            'entrance_full_name' => 'Entrance Full Name',
            'conducted_by' => 'Conducted By',
            'exam_duration' => 'Exam Duration',
            'exam_frequency' => 'Exam Frequency',
            'students_appeared_last_year' => 'Students Appeared Last Year',
            'number_of_seats' => 'Number Of Seats',
            'type_of_exam' => 'Type Of Exam',
            'category' => 'Category',
            'kind_of_exam' => 'Kind Of Exam',
            'application_availability' => 'Application Availability',
            'application_fees' => 'Application Fees',
            'application_deadline' => 'Application Deadline',
            'exam_date' => 'Exam Date',
            'max_marks' => 'Max Marks',
            'eligibility' => 'Eligibility',
            'application_process' => 'Application Process',
            'exam_brief' => 'Exam Brief',
            'exam_description' => 'Exam Description',
            'preparation_strategy' => 'Preparation Strategy',
            'fees_information' => 'Fees Information',
            'website' => 'Website',
            'exam_pattern' => 'Exam Pattern',
            'preparation_time' => 'Preparation Time',
            'coaching_required' => 'Coaching Required',
            'coaching_required1' => 'Coaching Required1',
            'coaching_normal_time' => 'Coaching Normal Time',
            'coaching_stretch_time' => 'Coaching Stretch Time',
            'application_url' => 'Application Url',
            'validity' => 'Validity',
            'added_on' => 'Added On',
            'added_by' => 'Added By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'is_active' => 'Is Active',
            'is_international_serach' => 'Is International Serach',
            'is_entrance_exam' => 'Is Entrance Exam',
            
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('entrance_id',$this->entrance_id);
        $criteria->compare('entrance_short_name',$this->entrance_short_name,true);
        $criteria->compare('entrance_full_name',$this->entrance_full_name,true);
        $criteria->compare('conducted_by',$this->conducted_by,true);
        $criteria->compare('exam_duration',$this->exam_duration);
        $criteria->compare('exam_frequency',$this->exam_frequency,true);
        $criteria->compare('students_appeared_last_year',$this->students_appeared_last_year);
        $criteria->compare('number_of_seats',$this->number_of_seats);
        $criteria->compare('type_of_exam',$this->type_of_exam,true);
        $criteria->compare('kind_of_exam',$this->kind_of_exam,true);
        $criteria->compare('application_availability',$this->application_availability,true);
        $criteria->compare('application_fees',$this->application_fees,true);
        $criteria->compare('application_deadline',$this->application_deadline,true);
        $criteria->compare('exam_date',$this->exam_date,true);
        $criteria->compare('max_marks',$this->max_marks);
        $criteria->compare('eligibility',$this->eligibility,true);
        $criteria->compare('application_process',$this->application_process,true);
        $criteria->compare('exam_brief',$this->exam_brief,true);
        $criteria->compare('exam_description',$this->exam_description,true);
        $criteria->compare('preparation_strategy',$this->preparation_strategy,true);
        $criteria->compare('fees_information',$this->fees_information,true);
        $criteria->compare('website',$this->website,true);
        $criteria->compare('exam_pattern',$this->exam_pattern,true);
        $criteria->compare('preparation_time',$this->preparation_time,true);
        $criteria->compare('coaching_required',$this->coaching_required,true);
        $criteria->compare('coaching_required1',$this->coaching_required1,true);
        $criteria->compare('coaching_normal_time',$this->coaching_normal_time,true);
        $criteria->compare('coaching_stretch_time',$this->coaching_stretch_time,true);
        $criteria->compare('application_url',$this->application_url,true);
        $criteria->compare('validity',$this->validity,true);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('added_by',$this->added_by);
        $criteria->compare('modified_on',$this->modified_on,true);
        $criteria->compare('modified_by',$this->modified_by);
        $criteria->compare('is_active',$this->is_active);
        $criteria->compare('is_international_serach',$this->is_international_serach);
        $criteria->compare('is_entrance_exam',$this->is_entrance_exam);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }
}