<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerEventTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_event_tracker".
 *
 * The followings are the available columns in table 'emailer_event_tracker':
 * @property integer $emailer_event_tracker_id
 * @property string $user_ref_id
 * @property string $sent_on
 * @property string $opened_on
 * @property integer $mail_type
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseEmailerEventTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerEventTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_event_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sent_on, mail_type', 'required'),
			array('mail_type', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>11),
			array('opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_event_tracker_id, user_ref_id, sent_on, opened_on, mail_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_event_tracker_id' => 'Emailer Event Tracker',
			'user_ref_id' => 'User Ref',
			'sent_on' => 'Sent On',
			'opened_on' => 'Opened On',
			'mail_type' => 'Mail Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_event_tracker_id',$this->emailer_event_tracker_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);
		$criteria->compare('mail_type',$this->mail_type);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}