<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailLeads is autogenerate by UniModel generator
 *
 * This is the model class for table "email_leads".
 *
 * The followings are the available columns in table 'email_leads':
 * @property string $email_leads_id
 * @property string $user_ref_id
 * @property string $contact_ref_id
 * @property string $email_type
 * @property string $form_type
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property StudentContactNumber $contactRef
 * @property TblUserMaster $userRef
 */
class BaseEmailLeads extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailLeads the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_leads';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, contact_ref_id', 'length', 'max'=>10),
			array('email_type', 'length', 'max'=>4),
			array('form_type', 'length', 'max'=>11),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_leads_id, user_ref_id, contact_ref_id, email_type, form_type, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contactRef' => array(self::BELONGS_TO, 'StudentContactNumber', 'contact_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_leads_id' => 'Email Leads',
			'user_ref_id' => 'User Ref',
			'contact_ref_id' => 'Contact Ref',
			'email_type' => 'Email Type',
			'form_type' => 'Form Type',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_leads_id',$this->email_leads_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('contact_ref_id',$this->contact_ref_id,true);
		$criteria->compare('email_type',$this->email_type,true);
		$criteria->compare('form_type',$this->form_type,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}