<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCareerImages is autogenerate by UniModel generator
 *
 * This is the model class for table "career_images".
 *
 * The followings are the available columns in table 'career_images':
 * @property string $career_image_id
 * @property string $career_ref_id
 * @property string $career_image
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupCareer $careerRef
 */
class BaseCareerImages extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CareerImages the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'career_images';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('career_ref_id, added_by', 'length', 'max'=>10),
			array('career_image', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('career_image_id, career_ref_id, career_image, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'careerRef' => array(self::BELONGS_TO, 'LookupCareer', 'career_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'career_image_id' => 'Career Image',
			'career_ref_id' => 'Career Ref',
			'career_image' => 'Career Image',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('career_image_id',$this->career_image_id,true);
		$criteria->compare('career_ref_id',$this->career_ref_id,true);
		$criteria->compare('career_image',$this->career_image,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}