<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentContactNumber');

class StudentContactNumber extends BaseStudentContactNumber
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('user_ref_id, contact_type_ref_id, added_by', 'required'),
            array('number', 'required', 'message' => '<div class="holder"><p>Number cannot be blank</p></div>', 'on' => 'Settings'),
            array('contact_type_ref_id, country_ref_id, extension, is_primary', 'numerical', 'integerOnly'=>true),
            array('user_ref_id, added_by, modified_by', 'length', 'max'=>10),
            array('phone_type', 'length', 'max'=>6),
            array('number', 'length', 'max'=>20),
            array('modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('student_contact_number_id, user_ref_id, phone_type, contact_type_ref_id, country_code, country_ref_id, number, extension, is_primary, added_on, added_by, modified_on, modified_by,is_verified,slide_version', 'safe', 'on'=>'search'),
            array('country_code', 'safe'),
            array('user_ref_id, contact_type_ref_id, added_on, added_by, country_code', 'required', 'on'=>'Settings'),
            array('contact_type_ref_id, country_ref_id, extension, is_primary', 'numerical', 'integerOnly'=>true, 'on'=>'Settings'),

            array('number', 'length', 'max'=>10,'tooLong'=>'<div class="holder">Number is too long (maximum is 10 numbers)</p></div>', 'on'=>'Settings'),
	       array('number', 'length', 'min'=>10,'tooShort'=>'<div class="holder">Number is too short (minimum is 10 numbers)</p></div>', 'on'=>'Settings'),
	        array('number', 'validateIfExists', 'message'=>'<div class="holder">You have already added this phone number</p></div>', 'on'=>'Settings'),
        );


    }

    
    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'phone_type, contact_type_ref_id, country_code, country_ref_id, number, is_primary' => 'personal_information',
        );
    }
    

    //TODO: #994 removed primary_phone field
    public static function getContactNumbers($UserId,$ContactType = false)
    {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$UserId."' and contact_type_ref_id = '".$ContactType."'";
        if($ContactType == 1) {
            $criteria->addCondition(" is_primary = 1");
        }
        $res = self::model()->find($criteria);
        $number = $res->attributes['number'];
        $country_code = $res->attributes['country_code'];        
        return $number ? ($country_code ? $country_code.' - ' : '') .$number : '';
        //return $res->attributes['country_code'].' - '.$res->attributes['number'];
    }


    public static function getFullContactNumbers($UserId,$ContactType = "")
    {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$UserId."' and contact_type_ref_id = '".$ContactType."' ";
        if($ContactType == 1) {
            $criteria->addCondition(" is_primary = 1");
        }
        $res = self::model()->find($criteria);
        return $res;
    }

    /*protected function beforeSave(){
        if(parent::beforeSave()){
            if($this->isNewRecord){
                $this->added_on = date('Y-m-d H:i:s');
            }else{
                $this->modified_on = date('Y-m-d H:i:s');
            }
            return true;

        }
        return false;
    }*/

    public  function validateIfExists() {

        if(!is_numeric($this->number*1) && !is_int($this->number*1)){
            $this->addError('number', '<div class="holder"><p>Decimal values not allowed</p></div>');
        }elseif(!preg_match('/^[0-9]+$/',$this->number)){
            $this->addError('number', '<div class="holder"><p>Enter only numeric values</p></div>');
        }
        if ($this->number[0] == 0) {
            $this->addError('number', "<div class='holder'><p>Number cannot start with '0'</p></div>");
        } else {
            $criteria = new CDbCriteria;
            $criteria->addCondition("user_ref_id = '".Yii::app()->user->sub_id."'", "AND");
            $criteria->addCondition("number = '".$this->number."'", "AND");
            $res = self::model()->find($criteria);
            if ($res) {
                $this->addError('number', '<div class="holder"><p>You have already added this phone number.</p></div>');
            }
        }
	}

    public static function getAllContactNumbers($UserId,$ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id, is_primary, country_code';
        $criteria->addCondition("user_ref_id = '".$UserId."'", "AND");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'", "AND");
        $criteria->order = "is_primary desc";
        //$criteria->condition = "user_ref_id = '".$UserId."' AND contact_type_ref_id = '".$ContactType."'";
        //$criteria->condition = "contact_type_ref_id = '".$ContactType."'";
        $res = self::model()->findAll($criteria);
        return $res;
	}

	public function getPrimaryPhoneId($userId, $ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'student_contact_number_id';
        $criteria->addCondition("user_ref_id = '".$userId."'", "AND");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'", "AND");
        $criteria->addCondition(" is_primary = 1 ", "AND");
        //$criteria->condition = "user_ref_id = '".$UserId."' AND contact_type_ref_id = '".$ContactType."'";
        //$criteria->condition = "contact_type_ref_id = '".$ContactType."'";
        $res = self::model()->find($criteria);
        return $res['student_contact_number_id'];
	}


    public function getPrimaryPhoneDetails($userId, $ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id, is_primary, country_code';
        $criteria->addCondition("user_ref_id = '".$userId."'", "AND");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'", "AND");
        $criteria->addCondition(" is_primary = 1 ", "AND");
        //$criteria->condition = "user_ref_id = '".$UserId."' AND contact_type_ref_id = '".$ContactType."'";
        //$criteria->condition = "contact_type_ref_id = '".$ContactType."'";
        $res = self::model()->find($criteria);
        return $res;
    }

    public function getSecondaryPhoneDetails($userId, $ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id, is_primary, country_code';
        $criteria->addCondition("user_ref_id = '".$userId."'", "AND");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'", "AND");
        $criteria->addCondition(" is_primary = 0 ", "AND");
        //$criteria->condition = "user_ref_id = '".$UserId."' AND contact_type_ref_id = '".$ContactType."'";
        //$criteria->condition = "contact_type_ref_id = '".$ContactType."'";
        $res = self::model()->findAll($criteria);
        return $res;
    }


    public static function deleteContactNumbers($userRefId=0, $contactTypeRefId=0, $otherFields = array()){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("user_ref_id = '".$userRefId."'", "AND");
        if($contactTypeRefId > 0){
            $cdbCriteria->addCondition("contact_type_ref_id = '".$contactTypeRefId."'", "AND");
        }
        if(count($otherFields) > 0){
            foreach($otherFields as $fieldAttributes){
                $cdbCriteria->addCondition($fieldAttributes['field'], $fieldAttributes['condition']);
            }
        }
        self::model()->deleteAll($cdbCriteria);
    }

    public static function addContactNumber($fields = array()){
        if(count($fields) > 0){
            $studentContactNumber = new StudentContactNumber();
            $studentContactNumber->setAttributes($fields);
            $studentContactNumber->save(false);
        }
    }
     public static function getContactNumbersOfParent($UserId,$ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id,contact_type_ref_id, is_primary, country_code';
        $criteria->with = 'contactTypeRef';
        $criteria->addCondition("user_ref_id = '".$UserId."'");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'");
        $criteria->limit = 2;
        //$criteria->condition = "user_ref_id = '".$UserId."' AND contact_type_ref_id = '".$ContactType."'";
        //$criteria->condition = "contact_type_ref_id = '".$ContactType."'";
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
    public static function validateDuplicateContact($userId, $number, $parentId)
    {
        $criteria = new CDbCriteria;
        $criteria->addCondition("user_ref_id = '" . $loginId . "'", "AND");
        $criteria->addCondition("number = '" . $number . "'", "AND");
        $criteria->addCondition("contact_type_ref_id != '" . $parentId . "'", "AND");
        //$criteria->addCondition("is_active = 1 ", "AND");
        $res = self::model()->find($criteria);
        return $res;
    }
    
    public static function getParentContactNumbers($UserId) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id,contact_type_ref_id, country_code';
        $criteria->with = 'contactTypeRef';
        $criteria->addCondition("user_ref_id = '".$UserId."'");
        $criteria->addCondition("contact_type_ref_id != 1");
        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getAllContactNumbersByType($userId=0, $contactType=1){
        $sql = "SELECT GROUP_CONCAT(CONCAT(country_code, '-', number)) AS contact_numbers FROM student_contact_number WHERE user_ref_id = '".$userId."' AND contact_type_ref_id = ".$contactType."";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        return @$result[0]['contact_numbers'];
    }

    public static function getContactDetails($UserId,$ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id, is_primary, country_code, is_verified';
        $criteria->addCondition("user_ref_id = '".$UserId."'", "AND");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'", "AND");
        $criteria->order = "is_primary desc";
        $res = self::model()->findAll($criteria);
        return $res;
    }


    public static function getFatherContactNumbers($UserId) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id,contact_type_ref_id, country_code';
        $criteria->with = 'contactTypeRef';
        $criteria->addCondition("user_ref_id = '".$UserId."'");
        $criteria->addCondition("contact_type_ref_id = 2");
        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getMotherContactNumbers($UserId) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id,contact_type_ref_id, country_code';
        $criteria->with = 'contactTypeRef';
        $criteria->addCondition("user_ref_id = '".$UserId."'");
        $criteria->addCondition("contact_type_ref_id = 3");
        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getGuardianContactNumbers($UserId) {
        $criteria = new CDbCriteria;
        $criteria->select = 'number, student_contact_number_id,contact_type_ref_id, country_code';
        $criteria->with = 'contactTypeRef';
        $criteria->addCondition("user_ref_id = '".$UserId."'");
        $criteria->addCondition("contact_type_ref_id = 4");
        $res = self::model()->findAll($criteria);
        return $res;
    }
}