<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseScholarship');

class Scholarship extends BaseScholarship{
    public $country_name;
    public $html_entity;
    public $type_name;
    public $deadlineDate;
  public static function model($className=__CLASS__){
    return parent::model($className);
  }
  
  
    /**
     * Custom model attribute to use in search
     * @var string
     */
   
    public $timeline = '';
  
  /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_name, scholarship_provider_name', 'required'),
            array('scholarship_provider_ref_id', 'required', 'message'=>'Scholarship Provider Type cannot be blank'),
			array('scholarship_provider_ref_id, currency_ref_id, notification_fees_currency_ref_id, deadline_day, deadline_month, deadline_year, scholarship_type_ref_id, added_by, modified_by,is_active', 'numerical', 'integerOnly'=>true),
			array('amount, notification_fees_amount', 'numerical'),
			array('scholarship_provider_name, number_of_scholarships', 'length', 'max'=>100),
			array('scholarship_name, website, Scholarship_Applicable_for', 'length', 'max'=>255),
			array('frequency, gender', 'length', 'max'=>6),
			array('eligibility_criteria, scholarship_description, contact_address, Scholarship_Amount_text, additional_information, application_requirements, destination_country_region, modified_on,tentative', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_id, scholarship_name, scholarship_provider_ref_id, scholarship_provider_name, website, eligibility_criteria, scholarship_description, Scholarship_Applicable_for, currency_ref_id, amount, frequency, Scholarship_Amount_text, contact_address, deadline_day, deadline_month, deadline_year, additional_information, number_of_scholarships, application_requirements, gender, scholarship_type_ref_id, added_on, added_by, modified_on, modified_by,is_active', 'safe', 'on'=>'search'),
		);
	} 
        
        protected function beforeSave(){
            if(parent::beforeSave()){
              if($this->isNewRecord){
                 $this->added_on = date('Y-m-d H:i:s');
              }else{
                $this->modified_on = date('Y-m-d H:i:s');
              }
              if(empty($this->currency_ref_id)) {
                $this->currency_ref_id = null;
              }
              return true;
              
            }
          return false;
        }
		
		  /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function getScholarshipList($type=false,$scholarshipName=false,$scholarshipIds=false)
    {
		
	     $where = $where1 = $where2 = $criteria  = $criteria1  ="";
		 
		 $dt = date('Y-n-d');
		
		 if(!empty($scholarshipName))
		  {			 
			$criteria = 'scholarship_name LIKE "%' . $scholarshipName . '%" AND ';
		  }		
		if(!empty($scholarshipIds))
		    $criteria = 'scholarship_id IN ('.$scholarshipIds.') AND ';	
			
		 if((!empty($_POST['sourceCountry']) || !empty($_POST['destinationCountry'])) && empty($scholarshipIds) && empty($_POST['scholarshipName']))
		      $criteria1 = 'WHERE scholarship_id = ""';
			  	
		 if((!empty($sourceCountry) || !empty($destinationCountry)) && empty($scholarshipIds) && empty($scholarshipName))
		     $criteria = 'scholarship_id = "" AND';
			
			
		  
	    switch ($type) {
		case "expired":
			$where .= "".$criteria." CONCAT(`deadline_year`,'-',`deadline_month`,'-',`deadline_day`) < DATE('".$dt."')
						AND `deadline_year` IS NOT NULL
						AND `deadline_month` IS NOT NULL
						AND `deadline_day` IS NOT NULL ";	
			$where1 .=" ".$criteria." `deadline_month` < ".date('n')." AND `deadline_year` IS NULL AND `deadline_day` IS NULL";	
			$where2 .=" ".$criteria." `deadline_month` < ".date('n')." AND `deadline_day` < ".date('j')." AND `deadline_year` IS NULL ";		
			break;
		case "valid":
			$where .= "".$criteria." CONCAT(`deadline_year`,'-',`deadline_month`,'-',`deadline_day`) >= DATE('".$dt."')
						AND `deadline_year` IS NOT NULL
						AND `deadline_month` IS NOT NULL
						AND `deadline_day` IS NOT NULL";
			$where1 .=	" ".$criteria." `deadline_month` >= ".date('n')."
						AND `deadline_year` IS NULL
						AND `deadline_day` IS NULL";
			$where2 .=" ".$criteria." `deadline_month` >= ".date('n')." AND `deadline_day` >= ".date('j')." AND `deadline_year` IS NULL ";	
			break;
		case "noDates":
			$where .= "";
			break;
		
	   }
	 
	 if($type == 'expired' || $type == 'valid')
	 { 
	   $sql = "SELECT
	                          `scholarship_id`,
							   `scholarship_name`,
								deadline_year,
								deadline_day,
								deadline_month,
								is_active,
								scholarship_provider_ref_id,
								scholarship_provider_name
		 						   	  FROM scholarship
							WHERE  ".$where." 
						       UNION ALL
						SELECT  
								 `scholarship_id`,
								 `scholarship_name`,
								  deadline_year,
								  deadline_day,
								  deadline_month,
								  is_active,
								  scholarship_provider_ref_id,
								  scholarship_provider_name
										FROM scholarship
								WHERE ".$where1."
						 UNION ALL
						SELECT  
								 `scholarship_id`,
								 `scholarship_name`,
								  deadline_year,
								  deadline_day,
								  deadline_month,
								  is_active,
								  scholarship_provider_ref_id,
								  scholarship_provider_name
										FROM scholarship
								WHERE ".$where2." order by deadline_year ASC,deadline_month ASC,deadline_day ASC";
	 }
	 if($type == 'all')
	 { 
	     if(!empty($scholarshipName))		  		 
		   	  $criteria1 = 'WHERE scholarship_name LIKE "%' . $scholarshipName . '%" ';		   	
		 if(!empty($scholarshipIds))
		      $criteria1 = 'WHERE scholarship_id IN ('.$scholarshipIds.')  ';				
	     if((!empty($_POST['sourceCountry']) || !empty($_POST['destinationCountry'])) && empty($scholarshipIds) && empty($_POST['scholarshipName']))
		      $criteria1 = 'WHERE scholarship_id = ""';			  	
		 if((!empty($sourceCountry) || !empty($destinationCountry)) && empty($scholarshipIds) && empty($scholarshipName))
		     $criteria = 'scholarship_id = "" AND';
			
		 $sql = "SELECT * FROM scholarship ".$criteria1." order by deadline_year ASC,deadline_month ASC,deadline_day ASC";
	 }
	 if($type == 'noDates')
	 {
		 $sql = "SELECT *
		   				FROM 
						 	scholarship 		  
		            	WHERE 
						   ".$criteria."  `deadline_month` IS NULL
						    AND `deadline_year` IS NULL
						    AND `deadline_day` IS NULL ";
	  }											  
	   $cmd = Yii::app()->db->createCommand($sql);	
	   $res = $cmd->queryAll();	  
	   return $res;		
	}
	 public function getScholarshipListCount($type=false,$scholarshipName=false,$scholarshipIds=false,$sourceCountry=false,$destinationCountry=false)
     {
			   		
		 $dt = date('Y-n-d');
	     $where = $where1 = $criteria = $criteria1 ="";
		
		 if(!empty($scholarshipName))
		  {			 
			$criteria = 'scholarship_name LIKE "%' . $scholarshipName . '%" AND ';
		  }		
		  if(!empty($scholarshipIds))
		    $criteria = 'scholarship_id IN ('.$scholarshipIds.') AND ';	
				
		 if((!empty($_POST['sourceCountry']) || !empty($_POST['destinationCountry'])) && empty($scholarshipIds) && empty($_POST['scholarshipName']))
		    $criteria = 'scholarship_id = "" AND';	
		
		  if((!empty($sourceCountry) || !empty($destinationCountry)) && empty($scholarshipIds) && empty($scholarshipName))
		    $criteria = 'scholarship_id = "" AND';	
		  
		  
		  
	    switch ($type) {
		case "expired":
			$where .= " ".$criteria." CONCAT(`deadline_year`,'-',`deadline_month`,'-',`deadline_day`) < DATE('".$dt."')
						AND `deadline_year` IS NOT NULL
						AND `deadline_month` IS NOT NULL
						AND `deadline_day` IS NOT NULL ";	
			$where1 .=" ".$criteria." `deadline_month` < ".date('n')." AND `deadline_year` IS NULL AND `deadline_day` IS NULL";	
			$where2 .=" ".$criteria." `deadline_month` < ".date('n')." AND `deadline_day` < ".date('j')." AND `deadline_year` IS NULL ";	
				
			break;
		case "valid":
			$where .= " ".$criteria." CONCAT(`deadline_year`,'-',`deadline_month`,'-',`deadline_day`) >= DATE('".$dt."')
						AND `deadline_year` IS NOT NULL
						AND `deadline_month` IS NOT NULL
						AND `deadline_day` IS NOT NULL";
			$where1 .=	" ".$criteria." `deadline_month` >= ".date('n')."
						AND `deadline_year` IS NULL
						AND `deadline_day` IS NULL";
			$where2 .=" ".$criteria." `deadline_month` >= ".date('n')." AND `deadline_day` >= ".date('j')." AND `deadline_year` IS NULL ";	
			break;
		case "noDates":
			$where .= "";
	   }
	
	 if($type == 'expired' || $type == 'valid')
	 { 
	    $sql = "SELECT `scholarship_id`,`scholarship_name` 
								FROM scholarship
						WHERE  ".$where."
						UNION ALL
						SELECT `scholarship_id`,`scholarship_name`
						FROM scholarship
						WHERE  ".$where1."					
						UNION ALL
						SELECT `scholarship_id`,`scholarship_name`
						FROM scholarship
						WHERE  ".$where2."  ";
	 }
	 if($type == 'all')
	 { 
		 if(!empty($scholarshipName))		  		 
		   	  $criteria1 = 'WHERE scholarship_name LIKE "%' . $scholarshipName . '%" ';		   	
		 if(!empty($scholarshipIds))
		      $criteria1 = 'WHERE scholarship_id IN ('.$scholarshipIds.')  ';				
		 if((!empty($_POST['sourceCountry']) || !empty($_POST['destinationCountry'])) && empty($scholarshipIds) && empty($_POST['scholarshipName']))
		      $criteria1 = 'WHERE scholarship_id = ""';
		 if((!empty($sourceCountry) || !empty($destinationCountry)) && empty($scholarshipIds) && empty($scholarshipName))
		    $criteria1 = 'scholarship_id = "" AND';	
			  
		 $sql = "SELECT scholarship_id FROM scholarship ".$criteria1."";
	 }
	 if($type == 'noDates')
	 {
		  $sql = "SELECT scholarship_id FROM scholarship WHERE ".$criteria." `deadline_month` IS NULL
						AND `deadline_year` IS NULL
						AND `deadline_day` IS NULL ";
	 }
												  
	   $cmd = Yii::app()->db->createCommand($sql);	
	   $res = $cmd->queryAll();
	  
	   return count($res);	  
	}
	
	/*public function getScholarshipDate($row, $data){
		//CVarDumper::dump(array($row),10,true);
		if(!empty($row->deadline_day))
		   return date("d-m-Y",mktime('0','0','0',$row->deadline_month,$row->deadline_day,$row->deadline_year));
	    else
		   return $row->deadline_month."-".$row->deadline_year;		
	} */
	
	
	/*public function getScholarshipDateStatus($row, $data){
		//CVarDumper::dump(array($row),10,true);
		if(!empty($row->deadline_day) && !empty($row->deadline_month) &&  !empty($row->deadline_year))
		{
		   $dbDate = mktime('0','0','0',$row->deadline_month,$row->deadline_day,$row->deadline_year);
		   $currentDate = mktime('0','0','0',date("m"),date("d"),date("Y"));
		}
	    else if(!empty($row->deadline_month) &&  !empty($row->deadline_year))
		{
		   $dbDate = mktime('0','0','0',$row->deadline_month,'0',$row->deadline_year);
		   $currentDate = mktime('0','0','0',date("m"),'0',date("Y"));	
		}
		
		
		if($dbDate >=$currentDate && (!empty($row->deadline_day) || !empty($row->deadline_month) ||  !empty($row->deadline_year)))
		{
			return '<img height="15" width="15" title="Active" src="'.Yii::app()->params['cbasepath'].'/mainadmin/images/active.png">';
		}
		else if($dbDate < $currentDate && (!empty($row->deadline_day) || !empty($row->deadline_month) ||  !empty($row->deadline_year)))
		{
			return '<img height="15" width="15" title="Inactive" src="'.Yii::app()->params['cbasepath'].'/mainadmin/images/inactive.png">';
		}
		else
		{
			return '<img height="15" width="15" title="Inactive" src="'.Yii::app()->params['cbasepath'].'/mainadmin/images/pending.png">';
		}
	} */
	
	public function getScholarshipDate($deadlineDate=false,$deadlineMonth=false,$deadlineYear=false){
		//CVarDumper::dump(array($row),10,true);
		if(!empty($deadlineDate) && !empty($deadlineMonth) && !empty($deadlineYear))
		   echo date("d-F-Y",mktime('0','0','0',$deadlineMonth,$deadlineDate,$deadlineYear));
	    else if(!empty($deadlineMonth) && !empty($deadlineYear))		   
		    echo date('F-Y', mktime('0','0','0',$deadlineMonth,'0',$deadlineYear));	
		else if(!empty($deadlineDate) && !empty($deadlineYear) && empty($deadlineMonth))		  
		    echo date('d-Y', mktime('0','0','0','0',$deadlineDate,$deadlineYear));
		else if(!empty($deadlineMonth) && empty($deadlineDate) && empty($deadlineYear))		 
		   echo date('F', mktime('0','0','0',$deadlineMonth,'0','0'));
		else if(!empty($deadlineMonth) && !empty($deadlineDate) && empty($deadlineYear))
		   echo date('d-F', mktime('0','0','0',$deadlineMonth,$deadlineDate,'0'));
	} 
	
   public function getScholarshipDateStatus($deadlineDate=false,$deadlineMonth=false,$deadlineYear=false){
		//CVarDumper::dump(array($row),10,true);
	
		if(!empty($deadlineDate) && !empty($deadlineMonth) &&  !empty($deadlineYear))
		{
		   $dbDate = mktime('0','0','0',$deadlineMonth,$deadlineDate,$deadlineYear);
		   $currentDate = mktime('0','0','0',date("m"),date("d"),date("Y"));
		}
	    else if(!empty($deadlineMonth) &&  !empty($deadlineYear) && empty($deadlineDate))
		{
		   $dbDate = mktime('0','0','0',$deadlineMonth,'0',$deadlineYear);
		   $currentDate = mktime('0','0','0',date("m"),'0',date("Y"));	
		}		
		else if(!empty($deadlineMonth) &&  empty($deadlineYear) &&  empty($deadlineDate))
		{
		   $deadlineYear = date('Y');
		   $dbDate = mktime('0','0','0',$deadlineMonth,'0',$deadlineYear);
		   $currentDate = mktime('0','0','0',date("m"),'0',date("Y"));	
		}
		
		else if(!empty($deadlineMonth) &&  empty($deadlineYear) &&  !empty($deadlineDate))
		{
		   $deadlineYear = date('Y');
		   $dbDate = mktime('0','0','0',$deadlineMonth,$deadlineDate,$deadlineYear);
		   $currentDate = mktime('0','0','0',date("m"),date("d"),date("Y"));	
		}
		
		
			
		if($dbDate >=$currentDate && (!empty($deadlineDate) || !empty($deadlineMonth) ||  !empty($deadlineYear)))
		{
			
			echo '<img height="15" width="15" title="Valid Date" src="'.Yii::app()->params['cbasepath'].'/mainadmin/images/active.png">';
		}
		else if($dbDate < $currentDate && (!empty($deadlineDate) || !empty($deadlineMonth) ||  !empty($deadlineYear)))
		{
			echo '<img height="15" width="15" title="Expired Date" src="'.Yii::app()->params['cbasepath'].'/mainadmin/images/inactive.png">';
		}
		else
		{
			echo '<img height="15" width="15" title="No Date" src="'.Yii::app()->params['cbasepath'].'/mainadmin/images/pending.png">';
		}
	} 
   
   	public function getScholarshipSuggestList($term = false){	  
	 
		$res = self::model()->findAll(array('condition'=>'scholarship_name like "%'.$term.'%" '));
		
		if($res > 0)
		{
		 foreach($res as $result)
		  {	
		
		  $op[] = array(
							'id' => $result['scholarship_id'],
							'value' => $result['scholarship_name'],  							                      
				);
		  }
		}
		
		return $op;
	 }
         
       public function getUniqueUrlPrimarykey($var1, $var2) {
            static $count = 0;
            $gereratedKey = hash('crc32b', $var1 . $var2);
            $rowData = self::model()->find('url_primary_key ="' . $gereratedKey . '"');
            $count++;
            if (!count($rowData)) {
                return $gereratedKey;
            } else {
                echo $var2 = $var2 . $count;
                return $this->getUniqueUrlPrimarykey($var1, $var2);
            }
        }
        
        public static function getScholarshipCount($params) {
            $criteria = new CDbCriteria;
            // Often used in search functions. Note: if passed value is empty, the WHERE is not added!
            $criteria->compare('scholarshipDepartments.course_level_ref_id', $params['study_level']);
            $criteria->compare('scholarshipDepartments.main_dept_ref_id', $params['main_dept']);
            $criteria->compare('scholarshipDepartments.sub_dept_ref_id', $params['sub_dept']);
            $criteria->compare('scholarshipDestinationCountries.country_ref_id', $params['source_institute']);
            $criteria->compare('scholarshipHostInstitutes.country_ref_id', $params['destination_institute']);
            if ($params['gender'] != '') {
                $criteria->addInCondition('t.gender', array('All', $params['gender']));
            }
            $count = self::model()->with('scholarshipDepartments', 'scholarshipHostInstitutes', 'scholarshipDestinationCountries')->count($criteria);

            return $count;
        }

        public function getScholarshipListByPreference($country, $dept) {
			
			$gender="'All'";
			$params['study_level'] = 6;
			$prefStudyLevels=array();
			if(!empty(Yii::app()->user->sub_id))
			{
				$user_det=TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);				
				if(!empty($user_det) && $user_det->gender)
				{
					if($user_det->gender =='F')
						$gender.=", 'Female'";
					else $gender.=", 'Male'";
				}
				
				$prefStudyLevels = $user_det->studentPreferredStudyLevels();
				foreach($prefStudyLevels as $id=>$level) {
					if($level['course_level_ref_id'] == '1' || $level['course_level_ref_id'] == '5')
					{
						$sLevel = $level['course_level_ref_id'] == '1' ? 3 : 6;
						$sLevels[] = $sLevel;
						$params['study_level'] = implode(',', $sLevels);
					}
				}
			}
			
						
            // trust based scholarships
            $providerCond = " AND scholarship_provider_ref_id = 1";
			$countryCond = " AND shi.country_ref_id = '$country' ";
			$mainDeptCond = " AND sd.main_dept_ref_id = '$dept' ";
			/*if($country != "") {
				$countryCond = " AND shi.country_ref_id = $country";
			}else
			{
				$countryCond = " AND shi.country_ref_id =''";
			}
			if($dept != "") {
				$mainDeptCond = " AND sd.main_dept_ref_id = $dept";
			} else
			{
				$mainDeptCond = " AND sd.main_dept_ref_id = ''";
			} */
			
			$study_level_cond=" AND sd.course_level_ref_id IN (".$params['study_level'].")";

            $sql = "SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.amount,sp.deadline_day,sp.deadline_month,sp.deadline_year,
			stp.type_name,lc.html_entity FROM scholarship sp
LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
LEFT JOIN `lookup_scholarship_type` stp ON stp.`scholarship_type_id` = sp.`scholarship_type_ref_id`
LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
LEFT JOIN lookup_scholarship_provider_type AS lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
WHERE sp.is_active = 1 AND sp.gender IN ( ".$gender.")".$providerCond.$countryCond.$mainDeptCond.$study_level_cond." GROUP BY sp.scholarship_id ORDER BY amount DESC LIMIT 4";

            //echo $countryCond. " ##". $providerCond; exit;
            $cmd = Yii::app()->db->createCommand($sql);
            $res = $cmd->queryAll();
            return $res;
        }

    public function getScholarshipSearchList($params, $returnAsGrid = true,$limit=false,$offset=false ) {


        $condition = $conditionForUniversity = array();
        if($params['provider_type'] != '') {
            $providerCond  = " AND scholarship_provider_ref_id = ". $params['provider_type'];
        }

        if($params['main_dept'] != '') {
            $mainDeptCond  = " AND sd.main_dept_ref_id = ". $params['main_dept'];
        }
        if(count($params['university'])>0){
            $uniArr = implode(',', $params['university']);
            $countryArr = implode(',', $params['country']);
            $condition[1] = "shi.uni_ref_id IN (".$uniArr.")";
            $condition[2] = "shi.country_ref_id IN (".$countryArr.")";
        }
        if($params['gender']!=''){
            $condition[3]  = "sp.gender IN ('All','".$params['gender']."')";
            $conditionForUniversity[1] = "sp.gender IN ('All','".$params['gender']."')";
        }
        if($params['study_level']!=''){
            $condition[4]  = "sd.course_level_ref_id =".$params['study_level'];
        }
        if($uniArr){
            $studyLevel = $params['study_level'];
            if($studyLevel!=''){
                $studyLevelcondition1  = " AND course_level_ref_id =".$studyLevel;
                $studyLevelcondition2 = " AND course_level=".$studyLevel;
            }
        }
		
        if($params['source_institute']!=''){
            $condition[5] =  "sdc.country_ref_id = ".$params['source_institute'];
            $conditionForUniversity[2] = "sdc.country_ref_id = ".$params['source_institute'];

        }
        if($params['destination_institute']!=''){
            $condition[6] =  "shi.country_ref_id = ".$params['destination_institute'];
            $conditionForUniversity[3] = "shi.country_ref_id = ".$params['destination_institute'];

        }
        if(!empty($params['ScholarshipSort']) && ($params['ScholarshipSort'] == "asc"))
            $order = 'amount ASC';
        else
            $order = 'amount DESC';
        $finalCondition = implode(' AND ', $condition);
        if($finalCondition ==''){

            $finalCondition = ' 1=1 ';
        }
        $finalConditionForUniversity = implode(' AND ', $conditionForUniversity);
        if($finalConditionForUniversity ==''){

            $finalConditionForUniversity = ' 1=1 ';
        }
        if($uniArr){

            $sqlSelect = "SELECT DISTINCT ld1.department_id FROM `tbl_university_master` um
                    LEFT JOIN tbl_uni_courses uc ON um.`uni_id`=uc.`uni_ref_id`
                    LEFT JOIN `lookup_department` ld ON uc.`department_ref_id`=ld.`department_id`
                    LEFT JOIN `lookup_department` ld1 ON ld1.`department_id`=ld.`main_dept_id`
                    WHERE uni_ref_id IN (".$uniArr.")  $studyLevelcondition2
                    AND um.is_active='y' AND uc.is_active='Y'";
            $cmd = Yii::app()->db->createCommand($sqlSelect);
            $res = $cmd->queryAll();
            $mainDeptIds = array();
            foreach ($res as $mainDept) {
                if($mainDept['department_id'])
                    $mainDeptIds[] = $mainDept['department_id'];
            }
            $main_dept_ids = implode(',', $mainDeptIds);


            $universityExtraCondition = " AND shi.university_type = 'Univariety ' AND sd.`main_dept_ref_id` IN (
                    $main_dept_ids ) $providerCond $mainDeptCond GROUP BY sp.scholarship_id
                    UNION ALL
                    SELECT   sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
                    FROM scholarship sp
                    LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
                    LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
                    LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
                    LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
                    LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
                    WHERE shi.country_ref_id IN (".$countryArr.")
                    AND shi.uni_ref_id IS NULL
                    $studyLevelcondition1
                    AND shi.university_type = 'Univariety'
                    AND sp.is_active = 1
                    AND sd.`main_dept_ref_id` IN (
                    $main_dept_ids ) AND $finalConditionForUniversity $providerCond $mainDeptCond";
        }
        $sqlSelect = "SELECT * FROM (SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
            FROM scholarship sp
            LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
            LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
            LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
            WHERE sp.is_active = 1 AND ".$finalCondition." $universityExtraCondition
             $providerCond $mainDeptCond GROUP BY sp.scholarship_name) t group by scholarship_id ORDER BY ".$order;

        if($limit){
            $sqlSelect.= " LIMIT ".$limit." OFFSET ".$offset." ";
        }

		//echo $sqlSelect; exit;

        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        return $res;
        // echo count($res);die;
        /*if($returnAsGrid){
         return new CArrayDataProvider($res, array(
                         'pagination'=>array(
                                 'pageSize'=>5,
                             ),
         ));
         }else{
             return $res;
         }*/


    }

    /*public function getScholarshipSearchList2($params, $returnAsGrid = true , $limit=false,$offset=false) {

        $condition = $conditionForUniversity = array();
        if($params['provider_type'] != '') {
            $providerCond  = " AND scholarship_provider_ref_id = ". $params['provider_type'];
        }

        if($params['main_dept'] != '') {
            $mainDeptCond  = " AND sd.main_dept_ref_id = ". $params['main_dept'];
        }
        if(count($params['university'])>0){
            $uniArr = implode(',', $params['university']);
            $countryArr = implode(',', array_unique($params['country']));
            $condition[1] = "shi.uni_ref_id IN (".$uniArr.")";
            $condition[2] = "shi.country_ref_id IN (".$countryArr.")";
        }
        if($params['gender']!=''){
            $condition[3]  = "sp.gender IN ('All','".$params['gender']."')";
            $conditionForUniversity[1] = "sp.gender IN ('All','".$params['gender']."')";
        }
        if($params['study_level']!=''){
            $condition[4]  = "sd.course_level_ref_id IN (".$params['study_level'].")";
        }
        if($uniArr){
            $studyLevel = $params['study_level'];
            if($studyLevel!=''){
                $studyLevelcondition1  = " AND course_level_ref_id IN (".$studyLevel.")";
                $studyLevelcondition2 = " AND course_level IN (".$studyLevel.")";
            }
        }
        if($params['source_institute']!=''){
            $condition[5] =  "sdc.country_ref_id IN (".$params['source_institute'].")";
            $conditionForUniversity[2] = "sdc.country_ref_id IN (".$params['source_institute'].")";

        }
        if($params['destination_institute']!=''){
            $condition[6] =  "shi.country_ref_id = ".$params['destination_institute'];
            $conditionForUniversity[3] = "shi.country_ref_id = ".$params['destination_institute'];

        }
        if(!empty($params['ScholarshipSort']) && ($params['ScholarshipSort'] == "asc"))
            $order = 'amount ASC';
        else
            $order = 'amount DESC';
        $finalCondition = implode(' AND ', $condition);
        if($finalCondition ==''){

            $finalCondition = ' 1=1 ';
        }
        $finalConditionForUniversity = implode(' AND ', $conditionForUniversity);
        if($finalConditionForUniversity ==''){

            $finalConditionForUniversity = ' 1=1 ';
        }
        if($uniArr){

            $sqlSelect = "SELECT DISTINCT ld1.department_id FROM `tbl_university_master` um
                    LEFT JOIN tbl_uni_courses uc ON um.`uni_id`=uc.`uni_ref_id`
                    LEFT JOIN `lookup_department` ld ON uc.`department_ref_id`=ld.`department_id`
                    LEFT JOIN `lookup_department` ld1 ON ld1.`department_id`=ld.`main_dept_id`
                    WHERE uni_ref_id IN (".$uniArr.")  $studyLevelcondition2
                    AND um.is_active='y' AND uc.is_active='Y'";
            $cmd = Yii::app()->db->createCommand($sqlSelect);
            $res = $cmd->queryAll();
            $mainDeptIds = array();
            foreach ($res as $mainDept) {
                if($mainDept['department_id'])
                    $mainDeptIds[] = $mainDept['department_id'];
            }
            $main_dept_ids = implode(',', $mainDeptIds);


            $universityExtraCondition = " AND shi.university_type = 'Univariety ' AND sd.`main_dept_ref_id` IN (
                    $main_dept_ids ) $providerCond $mainDeptCond GROUP BY sp.scholarship_id
                    UNION ALL
                    SELECT   sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`, lst.type_name
                    FROM scholarship sp
                    LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
                    LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
                    LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
                    LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
                    LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
                    LEFT JOIN lookup_scholarship_type lst on lst.scholarship_type_id=sp.scholarship_type_ref_id
                    WHERE shi.country_ref_id IN (".$countryArr.")
                    AND shi.uni_ref_id IS NULL
                    $studyLevelcondition1
                    AND shi.university_type = 'Univariety'
                    AND sp.is_active = 1
                    AND sd.`main_dept_ref_id` IN (
                    $main_dept_ids ) AND $finalConditionForUniversity $providerCond $mainDeptCond";
        }
        $sqlSelect = "SELECT * FROM (SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
            , lst.type_name FROM scholarship sp
            LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
            LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
            LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
            LEFT JOIN lookup_scholarship_type lst on lst.scholarship_type_id=sp.scholarship_type_ref_id
            WHERE sp.is_active = 1 AND ".$finalCondition."
             $universityExtraCondition
             $providerCond $mainDeptCond GROUP BY sp.scholarship_id) t group by scholarship_id ORDER BY ".$order;

        if($limit){
           $sqlSelect.= " LIMIT ".$offset.", ".$limit;
        }

        $cmd = Yii::app()->db->createCommand($sqlSelect);
       //echo $sqlSelect; exit;
        $res = $cmd->queryAll();
            return $res;
    }
    */
    public function getScholarshipSearchList2($params, $returnAsGrid = true , $limit=false,$offset=false) {

        $condition = $conditionForUniversity = array();
        if($params['provider_type'] != '') {
            $providerCond  = " AND scholarship_provider_ref_id = ". $params['provider_type'];
        }
        if($params['main_dept'] != '') {
            $mainDeptCond  = " AND sd.main_dept_ref_id = ". $params['main_dept'];
        }
        if($params['gender']!=''){
            $condition[3]  = "sp.gender IN ('All','".$params['gender']."')";
            $conditionForUniversity[1] = "sp.gender IN ('All','".$params['gender']."')";
        }
        if($params['study_level']!=''){
            $condition[4]  = "sd.course_level_ref_id IN (".$params['study_level'].")";
        }
		//Commented on 06-Aug-2014 due to incorrect results in dashboard and view all pages.
		/*
        if($params['source_institute']!=''){
            $condition[5] =  "sdc.country_ref_id IN (".$params['source_institute'].")";
            $conditionForUniversity[2] = "sdc.country_ref_id IN (".$params['source_institute'].")";

        }*/
        if($params['destination_institute']!=''){
            $condition[6] =  "shi.country_ref_id = ".$params['destination_institute'];
            $conditionForUniversity[3] = "shi.country_ref_id = ".$params['destination_institute'];

        }
        if($params['filter_college'] != '') {
            $condition[7]  = " shi.uni_ref_id = ". $params['filter_college'];
        }
        if(!empty($params['ScholarshipSort']) && ($params['ScholarshipSort'] == "asc"))
            $order = 'amount ASC';
        else
            $order = 'amount DESC';
        $finalCondition = implode(' AND ', $condition);
        if($finalCondition ==''){

            $finalCondition = ' 1=1 ';
        }
        $finalConditionForUniversity = implode(' AND ', $conditionForUniversity);
        if($finalConditionForUniversity ==''){

            $finalConditionForUniversity = ' 1=1 ';
        }

        $sqlSelect = "SELECT * FROM (SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
            , lst.type_name FROM scholarship sp
            LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
            LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
            LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
            LEFT JOIN lookup_scholarship_type lst on lst.scholarship_type_id=sp.scholarship_type_ref_id
            WHERE sp.is_active = 1 AND ".$finalCondition."
             $providerCond $mainDeptCond GROUP BY sp.scholarship_id) t group by scholarship_id ORDER BY ".$order;

        if($limit){
           $sqlSelect.= " LIMIT ".$offset.", ".$limit;
        }

        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getScholarshipAboutData($scholarshipId){
        $criteria = new CDbCriteria;
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $criteria->with = array('scholarshipDepartments'=>array('select'=>'course_level_ref_id'),'scholarshipProviderRef'=>array('select'=>'provider_type'));
        $scholarshipData = self::model()->find($criteria);
        $result['provider_name'] = $scholarshipData->scholarship_provider_name;
        $result['number_of_scholarships'] = $scholarshipData->number_of_scholarships;
        $result['scholarship_description'] = $scholarshipData->scholarship_description;
        
        $result['provider_type'] = $scholarshipData->scholarshipProviderRef->provider_type;
        $list['study_level'] = array();
        foreach($scholarshipData->scholarshipDepartments as $data){ //print_r($scholarshipData->scholarshipDepartments[0]->attributes);die;
            if($data->course_level_ref_id == 3){
                $list['study_level'][] = 'Postgraduate';
            }elseif($data->course_level_ref_id == 6){
                $list['study_level'][] = 'Undergraduate';
            }else{
                $list['study_level'][] = $data->courseLevelRef->course_level;    
            }
        }
        $result['study_level'] = implode(' / ',  array_unique($list['study_level'],SORT_STRING));
       return $result;
    }
    
     public static function getScholarshipHeaderData($scholarshipId){
        $scholarshipData = self::model()->with(array('scholarshipTypeRef'=>array('select'=>'type_name')))->find('scholarship_id='.$scholarshipId);
        $result['scholarship_name'] = $scholarshipData->scholarship_name;
        $result['scholarship_provider_name'] = $scholarshipData->scholarship_provider_name;
        $result['website'] = $scholarshipData->website;
        $result['scholarship_type'] = $scholarshipData->scholarshipTypeRef->type_name;
        return $result;
    }
    
    public static function getScholarshipDetail($scholarshipId){
        
        $criteria = new CDbCriteria;
        $criteria->select = 'scholarship_id,Scholarship_Amount_text';
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $scholarshipData = self::model()->find($criteria);
        $result['amount'] = $scholarshipData->Scholarship_Amount_text;
        return $result;
//        $criteria = new CDbCriteria;
//        $criteria->condition = 'scholarship_id=:id';
//        $criteria->params = array(':id'=>$scholarshipId);
//        $criteria->with = array('currencyRef'=>array('select'=>'html_entity'));
//        $scholarshipData = self::model()->find($criteria);
//        $hostCountryList = array();
//        $destCountryList = array();
//        $ethanicityList = array();
//        $departmentList = array();
//        $departmentMainIds = array();
//        
//        $result['amount'] = $scholarshipData->amount;
//        $result['frequency'] = $scholarshipData->frequency;
//        if($scholarshipData->currency_ref_id == 1)
//            $result['currency'] = 'Rs.';
//        else
//            $result['currency'] = $scholarshipData->currencyRef->html_entity;
//        $result['scholarship_amount_text'] = $scholarshipData->Scholarship_Amount_text;
//        $result['destination_country_region'] = $scholarshipData->destination_country_region;
//        $criteria2 = new CDbCriteria;
//        $criteria2->select = 'scholarship_destination_country_id';
//        $criteria2->with = array('countryRef'=>array('select'=>'country_name'));
//        $criteria2->condition = 'scholarship_ref_id=:id';
//        $criteria2->params = array(':id'=>$scholarshipId);
//        $scholarshipDestCountryData = ScholarshipDestinationCountry::model()->findAll($criteria2);
//        foreach($scholarshipDestCountryData as $data){ 
//            $hostCountryList[] = $data->countryRef->country_name; 
//        }
//        $result['host_countries'] = array_unique($hostCountryList, SORT_STRING);
//        sort($result['host_countries']);
//        $result['university_list'] = array();
//        $criteria1 = new CDbCriteria;
//        $criteria1->select = 'university_type, uni_ref_id, non_univariety_uni_name';;
//        $criteria1->with = array('countryRef'=>array('select'=>'country_name'),'uniRef'=>array('select'=>'uni_name'));
//        $criteria1->condition = 'scholarship_ref_id=:id';
//        $criteria1->params = array(':id'=>$scholarshipId);
//        $scholarshipHostData = ScholarshipHostInstitute::model()->findAll($criteria1);
//        foreach($scholarshipHostData as $destData){
//           // print_r($destData->countryRef->attributes);die;
//            $destCountryList[] = $destData->countryRef->country_name;
//             if($destData->university_type =='Univariety' && ($destData->uni_ref_id == null || $destData->uni_ref_id == '')){
//                  $result['university_list'][$destData->countryRef->country_name][$destData->countryRef->country_name] = 'Applicable to any college in '.$destData->countryRef->country_name;
//                  $CountryList[]  = $destData->countryRef->country_name;
//                  //$result['show_count_txt'][$destData->countryRef->country_name] = 'All';
//             }elseif($destData->uni_ref_id >0){
//                $universityName = $destData->uniRef->uni_name;
//                if(!in_array($universityName,$result['university_list'])){
//                    $CountryList[] = $destData->countryRef->country_name;
//                    $result['university_list'][$destData->countryRef->country_name][$destData->uniRef->uni_id] = $universityName;
//                }
//            }elseif($destData->university_type =='NonUnivariety' && ($destData->non_univariety_uni_name == null || $destData->non_univariety_uni_name == '')){
//                $result['university_list'][$destData->countryRef->country_name][$destData->countryRef->country_name] = 'Applicable to any college in '.$destData->countryRef->country_name;
//            }elseif($destData->non_univariety_uni_name!=''){
//                $universityName = $destData->non_univariety_uni_name;
//                if(!in_array($universityName,$result['university_list'])){                    
//                    $result['university_list'][$destData->countryRef->country_name][$universityName] = $universityName;
//                }
//            }
//        }
//        asort($result['university_list']);
//        $result['dest_countries'] = array_unique($destCountryList, SORT_STRING);
//        sort($result['dest_countries']);
//               
//        //$result['university_list'] = array_unique($universityList, SORT_STRING);
//        $result['host_institution_commentary'] = $scholarshipData->host_institution_commentary;
//        $criteria4 = new CDbCriteria;
//        $criteria4->select = 'scholarship_target_id';
//        $criteria4->with = array('scholarshipTargetGroupRef'=>array('select'=>'group_name'));
//        $criteria4->condition = 'scholarship_ref_id=:id';
//        $criteria4->params = array(':id'=>$scholarshipId);
//        $scholarshipTargetsData = ScholarshipTarget::model()->findAll($criteria4);
//        foreach($scholarshipTargetsData as $ethanicityData){ 
//            $ethanicityList[] = $ethanicityData->scholarshipTargetGroupRef->group_name; 
//        }
//        $result['target_ethanicity'] = array_unique($ethanicityList, SORT_STRING);
//        sort($result['target_ethanicity']);
//           
//        return $result;
    }
    
     public static function getScholarshipRequirementData($scholarshipId){
       $criteria = new CDbCriteria;
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $criteria->with = array('scholarshipAges','scholarshipFinancialNeeds','scholarshipEligibilityClasses','scholarshipEligibilityEntrances');
        $scholarshipData = self::model()->find($criteria);
        $result['gender'] = $scholarshipData->gender;
        $result['eligibility_criteria'] = $scholarshipData->eligibility_criteria;
        foreach($scholarshipData->scholarshipAges as $data){
             $result['age_criteria']['comparison_operator'] = $data->comparison_operator;
             $result['age_criteria']['age'] = $data->age;
            break;
        }
        foreach($scholarshipData->scholarshipFinancialNeeds as $data){ 
             $result['income']['comparison_operator'] = $data->comparison_operator;
             $result['income']['currency'] = $data->currencyRef->html_entity;
             if($data->currencyRef->currency_code == 'INR'){
                $result['income']['currency'] = 'Rs.';
             }else{
                $result['income']['currency'] = $data->currencyRef->html_entity;;
             }
             $result['income']['amount'] = $data->amount;
             $result['category'] = $data->reservationRef->reservation_name;
            break;
        }
        foreach($scholarshipData->scholarshipEligibilityClasses as $data){ 
             $result['class']['class'] = $data->class;
             $result['class']['marks_type'] = $data->marks_type;
             $result['class']['marks_required'] = $data->marks_required;
             $result['class']['grade_required'] = $data->grade_required;
            break;
        }
        foreach($scholarshipData->scholarshipEligibilityEntrances as $data){ 
             $result['entrance']['entrance_name'] = $data->entranceRef->entrance_short_name?$data->entranceRef->entrance_short_name:$data->entranceRef->entrance_full_name;
             $result['entrance']['entrance_id'] = $data->entrance_ref_Id;
             $result['entrance']['marks_required'] = $data->marks_required;
             $result['entrance']['max_marks'] = $data->entranceRef->max_marks;
            break;
        }
       return $result;
    }
    
    public static function getScholarshipApplicationData($scholarshipId){
        $criteria = new CDbCriteria;
        $criteria->select = 'scholarship_id, deadline_day, deadline_month, deadline_year, application_requirements,additional_information';
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $scholarshipData = self::model()->find($criteria);

        $result['day'] = $scholarshipData->deadline_day;
        $result['month'] = $scholarshipData->deadline_month;
        $result['year'] = $scholarshipData->deadline_year;
        $result['app_requirement'] = $scholarshipData->application_requirements;
        $result['additional_information'] = $scholarshipData->additional_information;
        
        return $result;
//        $criteria = new CDbCriteria;
//        $criteria->condition = 'scholarship_id=:id';
//        $criteria->params = array(':id'=>$scholarshipId);
//        $scholarshipData = self::model()->with(array('notificationFeesCurrencyRef'=>array('select'=>'currency_code, html_entity')))->find($criteria);
//        $result['amount'] = $scholarshipData->notification_fees_amount;
//        if($scholarshipData->notificationFeesCurrencyRef->currency_code == 'INR'){
//            $result['currency'] = 'Rs.';
//        }else{
//            $result['currency'] = $scholarshipData->notificationFeesCurrencyRef->html_entity;
//        }
//        $result['day'] = $scholarshipData->deadline_day;
//        $result['month'] = $scholarshipData->deadline_month;
//        $result['year'] = $scholarshipData->deadline_year;
//        $result['app_requirement'] = $scholarshipData->application_requirements;
//        $result['additional_information'] = $scholarshipData->additional_information;
//        
//       return $result;
    }
    
     public static function getScholarshipAdditionalData($scholarshipId){
        $criteria = new CDbCriteria;
        $criteria->select = 'scholarship_id, additional_information';
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $scholarshipData = self::model()->find($criteria);

        $result['additional_data'] = $scholarshipData->additional_information;
        
        return $result;
     }
    
    public static function getScholarshipIdFromHash($hashScholarshipId){
        $criteria = new CDbCriteria();
        $criteria->select = 'scholarship_id, url_primary_key, scholarship_name, is_active';
        $criteria->condition = "url_primary_key=:id";
        $criteria->params = array(':id' => $hashScholarshipId);

        $data = self::model()->find($criteria);

        $scholarshipData['scholarship_id'] = $data->scholarship_id;
        $scholarshipData['url_primary_key'] = $data->url_primary_key;
        $scholarshipData['scholarship_name'] = $data->scholarship_name;
        $scholarshipData['is_active'] = $data->is_active;
        
        return $scholarshipData;
    }
    
    public static function getScholarshipUrlData($scholarshipId, $byScholarshipHash = 0){
         
        $criteria = new CDbCriteria();
        $criteria->select = 'scholarship_id, url_primary_key, scholarship_name, seo_keyword';
        
        if($byScholarshipHash) {
            $criteria->condition = "url_primary_key=:id";
            $criteria->params = array(':id' => $scholarshipId);
        } else {
            $criteria->condition = "scholarship_id=:id";
            $criteria->params = array(':id' => $scholarshipId);
        }
        
        $data = self::model()->find($criteria);

        $scholarshipUrlData['scholarship_id'] = $data->scholarship_id;
        $scholarshipUrlData['url_primary_key'] = $data->url_primary_key;
        $scholarshipUrlData['scholarship_name'] = $data->scholarship_name;
        $scholarshipUrlData['seo_keyword'] = $data->seo_keyword;
       
        return $scholarshipUrlData;
    }
	public static function getScholarshipSearchLists($scholarshipName=false,$scholarshipIds=false)
	{	
        $criteria = new CDbCriteria();
        $criteria->select = 'scholarship_id,
								  scholarship_name,
								  deadline_year,
								  deadline_day,
								  deadline_month,
								  is_active,
								  scholarship_provider_ref_id,
								  scholarship_provider_name';
       	
		
		  if(!empty($scholarshipName))
		  {			 
			$criteria->condition = 'scholarship_name LIKE "%' . $scholarshipName . '%"';
		  }		
		  if(!empty($scholarshipIds))
		    $criteria->condition = 'scholarship_id IN ('.$scholarshipIds.') ';	
				
		  if((!empty($_POST['sourceCountry']) || !empty($_POST['destinationCountry'])) && empty($scholarshipIds) && empty($_POST['scholarshipName']))
		    $criteria->condition = 'scholarship_id = ""';			
		  
		    $criteria->order = 'deadline_year ASC,deadline_month ASC,deadline_day ASC' ;
		 	
            $data = self::model()->findAll($criteria);
        
            return $data;
    } 
    public static function getScholarshipAutoCompleteList($searchTerm, $limit = 20, $status = ''){
        $criteria = new CDbCriteria;
        $criteria->alias = 'sch';
        
        $criteria->condition = "sch.scholarship_name LIKE '%$searchTerm%' AND sch.is_active = '$status'";

        $criteria->group = 'sch.scholarship_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN sch.scholarship_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), sch.scholarship_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }
    
    public static function getApplicableUniversityList($scholarshipId){
        $criteria = new CDbCriteria;
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $criteria->with = array('scholarshipHostInstitutes');
        $scholarshipData = self::model()->find($criteria);
        $result['university_list'] = array();
        $result['country_list'] = array();
        $result['uni_count'] = $i = 0;
        $result['name'] = $scholarshipData->scholarship_name;
        foreach($scholarshipData->scholarshipHostInstitutes as $destData){
            $result['country_list'] = $destData->countryRef->country_name;
             if($destData->university_type =='Univariety' && ($destData->uni_ref_id == null || $destData->uni_ref_id == '')){
                  $result['university_list'][$destData->countryRef->country_name] = 'Applicable to any college in '.$destData->countryRef->country_name;
             }elseif($destData->uni_ref_id >0 && $destData->uniRef->is_active == 'Y'){
                $universityName = $destData->uniRef->uni_name;
                if(!in_array($universityName,$result['university_list'])){
                    $result['university_list'][$destData->uniRef->uni_id]['uni_name'] = $universityName;
                    $result['university_list'][$destData->uniRef->uni_id]['country_ref_id'] = $destData->uniRef->country_ref_id;
                    $result['university_list'][$destData->uniRef->uni_id]['country_name'] = $destData->uniRef->countryRef->country_name;
                    $result['university_list'][$destData->uniRef->uni_id]['state_name'] = $destData->uniRef->stateRef->name ? $destData->uniRef->stateRef->name.", " : '';
                    $result['university_list'][$destData->uniRef->uni_id]['city_name'] = $destData->uniRef->cityRef->city_name ? $destData->uniRef->cityRef->city_name.", " : '';
                    $result['uni_count'] = ++$i;
                }
            }elseif($destData->university_type =='NonUnivariety' && ($destData->non_univariety_uni_name == null || $destData->non_univariety_uni_name == '')){
                $result['university_list'][$destData->countryRef->country_name] = 'Applicable to any college in '.$destData->countryRef->country_name;
            }elseif($destData->non_univariety_uni_name!=''){
                $universityName = $destData->non_univariety_uni_name;
                if(!in_array($universityName,$result['university_list'])){
                    $result['university_list'][$universityName] = $universityName;
                }
            }
        }
        asort($result['university_list']);
        return $result;
    }
   
    public static function getApplicableUniversityListSolr($scholarshipId){
        $criteria = new CDbCriteria;
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $criteria->with = array('scholarshipHostInstitutes');
        $scholarshipData = self::model()->find($criteria);
        $result = array();
        $i=0;
        foreach($scholarshipData->scholarshipHostInstitutes as $destData){            
             if($destData->uni_ref_id >0 && $destData->uniRef->is_active == 'Y'){
                $universityName = $destData->uniRef->uni_id;
                if(!in_array($universityName,$result)){
                    array_push($result,$universityName); $i++;
                }
            }
            elseif($destData->non_univariety_uni_name!=''){
                $universityName = $destData->non_univariety_uni_name;
                if(!in_array($universityName,$result)){
                    array_push($result,$universityName); $i++;
                   // $result['university_list'][$universityName] = $universityName;
                }
            }
        }
        asort($result);
        return $result;
    }
    
    
    
    public static function checkScholarshipEligibility($scholarshipId, $gender, $countryId) {
        
        $criteria = new CDbCriteria;
        $criteria->with = array('scholarshipDestinationCountries');
        $criteria->condition = 'scholarship_id=:id AND (gender=:gender OR gender="ALL") AND scholarshipDestinationCountries.country_ref_id=:countryId';
        $criteria->params = array(':id'=>$scholarshipId, ':gender' => $gender, ':countryId' => $countryId);
        $scholarshipData = self::model()->findAll($criteria);
        return count($scholarshipData) ? true : false;
    }
    
     public static function getScholarshipContactData($scholarshipId){
        $criteria = new CDbCriteria;
        $criteria->select = 'scholarship_id, website,`address1`,`address2`,`city_ref_id`,`country_ref_id`,`postcode`,`email_id`';
        $criteria->condition = 'scholarship_id=:id';
        $criteria->params = array(':id'=>$scholarshipId);
        $scholarshipData = self::model()->find($criteria);

        $result['address1'] = $scholarshipData->address1;
        $result['address2'] = $scholarshipData->address2;
        if($scholarshipData->country_ref_id){
            $result['country_name'] = TblCountryMaster::getCountryName($scholarshipData->country_ref_id);
        }
        if($scholarshipData->city_ref_id){
            $result['city_name'] = TblCityMaster::getCityName($scholarshipData->city_ref_id);
        }
        $result['postcode'] = $scholarshipData->postcode;
        $result['email_id'] = $scholarshipData->email_id;
        $result['website'] = $scholarshipData->website;
        
        return $result;
     }
     
    // Using this function in header search
    public static function getScholarshipHeaderSearchList($searchTerm, $limit = 20, $status = '', $uniIdArr = array()) {
        
//        if(count($uniIdArr)) {
//             $cond = " OR uni_ref_id IN (". implode(",", $uniIdArr) .")";
//        }
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';        
        //$criteria->join = "LEFT JOIN scholarship_host_institute as shi ON shi.scholarship_ref_id = um.scholarship_id";
        $criteria->join = "LEFT JOIN `tag_scholarship` ts ON um.scholarship_id = ts.scholarship_ref_id";
        $criteria->join .= " LEFT JOIN tag tg ON tg.tag_id = ts.tag_ref_id";        
        $criteria->condition = "(um.scholarship_name LIKE '%$searchTerm%' OR tg.tag_name LIKE '%$searchTerm%') AND um.is_active = '$status'" . $cond; 

        $criteria->group = 'um.scholarship_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN um.scholarship_id LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.scholarship_name,(CASE WHEN tg.tag_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), tg.tag_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    public function getScholarshipSearchListOutplacement($params, $returnAsGrid = true ) {


        $condition = $conditionForUniversity = array();
        if($params['provider_type'] != '') {
            $providerCond  = " AND scholarship_provider_ref_id = ". $params['provider_type'];
        }

        if($params['main_dept'] != '') {
            $mainDeptCond  = " AND sd.main_dept_ref_id IN (". $params['main_dept'].")";
        }
        if(count($params['university'])>0){
            $uniArr = implode(',', $params['university']);
            $countryArr = implode(',', $params['country']);
            $condition[1] = "shi.uni_ref_id IN (".$uniArr.")";
            $condition[2] = "shi.country_ref_id IN (".$countryArr.")";
        }
        if (count($params['country']) > 0) {
            $countryArr = implode(',', $params['country']);
            $condition[2] = "shi.country_ref_id IN (".$countryArr.")";
        }

        if($params['gender']!=''){
            $condition[3]  = "sp.gender IN ('All','".$params['gender']."')";
            $conditionForUniversity[1] = "sp.gender IN ('All','".$params['gender']."')";
        }
        if($params['study_level']!=''){
            $condition[4]  = "sd.course_level_ref_id in (".$params['study_level'].")";
        }
        if($uniArr){
            $studyLevel = $params['study_level'];
            if($studyLevel!=''){
                $studyLevelcondition1  = " AND course_level_ref_id in (".$studyLevel.")";
                $studyLevelcondition2 = " AND course_level IN (".$studyLevel.")";
            }
        }
        if($params['source_institute']!=''){
            $condition[5] =  "sdc.country_ref_id IN (".$params['source_institute'].")";
            $conditionForUniversity[2] = "sdc.country_ref_id IN (".$params['source_institute'].")";

        }
        if($params['destination_institute']!=''){
            $condition[6] =  "shi.country_ref_id = ".$params['destination_institute'];
            $conditionForUniversity[3] = "shi.country_ref_id = ".$params['destination_institute'];

        }
        if(!empty($params['ScholarshipSort']) && ($params['ScholarshipSort'] == "asc"))
            $order = 'amount ASC';
        else
            $order = 'amount DESC';
        $finalCondition = implode(' AND ', $condition);
        if($finalCondition ==''){
            $finalCondition = ' 1=1 ';
        }
        $finalConditionForUniversity = implode(' AND ', $conditionForUniversity);
        if($finalConditionForUniversity ==''){
            $finalConditionForUniversity = ' 1=1 ';
        }
        if($uniArr){
            $sqlSelect = "SELECT DISTINCT ld1.department_id FROM `tbl_university_master` um
                    LEFT JOIN tbl_uni_courses uc ON um.`uni_id`=uc.`uni_ref_id`
                    LEFT JOIN `lookup_department` ld ON uc.`department_ref_id`=ld.`department_id`
                    LEFT JOIN `lookup_department` ld1 ON ld1.`department_id`=ld.`main_dept_id`
                    WHERE uni_ref_id IN (".$uniArr.")  $studyLevelcondition2
                    AND um.is_active='y' AND uc.is_active='Y'";
            $cmd = Yii::app()->db->createCommand($sqlSelect);
            $res = $cmd->queryAll();
            $mainDeptIds = array();
            foreach ($res as $mainDept) {
                if ($mainDept['department_id']) {
                    $mainDeptIds[] = $mainDept['department_id'];
                }
            }
            if(!empty($main_dept_ids))
			{
				$main_dept_ids = implode(',', $mainDeptIds);
				$main_dept_condition="sd.`main_dept_ref_id` IN (
                    $main_dept_ids ) AND $finalConditionForUniversity $providerCond $mainDeptCond";
				$main_first_dept_condition=" sd.`main_dept_ref_id` IN (
                    $main_dept_ids ) $providerCond";
			}
			else{
				$main_dept_condition=" AND $finalConditionForUniversity $providerCond $mainDeptCond";
				$main_first_dept_condition="$providerCond";
			}

            $universityExtraCondition = " AND shi.university_type = 'Univariety ' $main_first_dept_condition $mainDeptCond GROUP BY sp.scholarship_id
                    UNION ALL
                    SELECT   sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
                    FROM scholarship sp
                    LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
                    LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
                    LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
                    LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
                    LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
                    WHERE shi.country_ref_id IN (".$countryArr.")
                    AND shi.uni_ref_id IS NULL
                    $studyLevelcondition1
                    AND shi.university_type = 'Univariety'
                    AND sp.is_active = 1 $main_dept_condition";
        }
        $sqlSelect = "SELECT * FROM (SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
            FROM scholarship sp
            LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
            LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
            LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
            WHERE sp.is_active = 1 AND ".$finalCondition."
             $universityExtraCondition
             $providerCond $mainDeptCond GROUP BY sp.scholarship_id) t group by scholarship_id ORDER BY ".$order;

        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        // echo count($res);die;
        if($returnAsGrid){
            return new CArrayDataProvider($res, array(
                'pagination'=>array(
                    'pageSize'=>5,
                ),
            ));
        }else{
            return $res;
        }
	}

    public static function updateScholarshipUrlPrimaryKey($scholarshipId=0, $scholarshipName = ''){
        $urlPrimaryKey = self::getUniqueUrlPrimarykey($scholarshipId, $scholarshipName);
        $scholarship = self::model()->findByPk($scholarshipId);
        $scholarship->url_primary_key = $urlPrimaryKey;
        $scholarship->save(false);
    }

    public static function getShortlistUniversityList($countryId,$departmentId,$providerId = ''){

        $sql = "SELECT shi.uni_ref_id,tu.uni_name FROM scholarship sp
                INNER JOIN `scholarship_host_institute` shi ON shi.scholarship_ref_id = sp.scholarship_id
                INNER JOIN student_shortlist_university ssu ON ssu.uni_ref_id = shi.uni_ref_id
                INNER JOIN tbl_university_master tu ON tu.uni_id = shi.uni_ref_id
                LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id`= sp.scholarship_id
                WHERE ssu.user_ref_id = ".Yii::app()->user->sub_id." AND sd.course_level_ref_id IN (6) AND tu.is_active = 'Y' AND ssu.shortlist_status !='Reject' ";
        if($providerId)
            $sql.= " AND sp.scholarship_provider_ref_id = ".$providerId;
        if($countryId)
            $sql.= " AND shi.country_ref_id=".$countryId;
        if($departmentId)
            $sql.= " AND sd.main_dept_ref_id=".$departmentId;

        $sql.= " GROUP BY shi.uni_ref_id";

        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        $universities = Array();

        foreach($result as $row){
            $universities[$row['uni_ref_id']] = CHtml::decode($row['uni_name']);
        }
        return $universities;
    }

    public static function getScholarshipLists($params, $limit=false,$offset=false ){
        $condition = $conditionForUniversity = array();
        if($params) {
            $providerCond  = " AND sp.scholarship_provider_ref_id = ". $params['type'];
            $countryCond = " AND shi.country_ref_id = ".$params['countryId'];
        }
        $sqlSelect = "SELECT * FROM (SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,`uni_ref_id`
            FROM scholarship sp
            LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
            LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
            LEFT JOIN scholarship_destination_country as sdc ON sp.scholarship_id = sdc.scholarship_ref_id
            LEFT JOIN lookup_currency as lc ON sp.currency_ref_id = lc.currency_id
            LEFT JOIN lookup_scholarship_provider_type as lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
            WHERE sp.is_active = 1 ".$providerCond.$countryCond." AND sd.course_level_ref_id = 6
            AND sp.gender IN ('All','Female','Male')
            GROUP BY sp.scholarship_name) t GROUP BY scholarship_id ORDER BY amount DESC";

        if($limit){
            $sqlSelect.= " LIMIT ".$limit." OFFSET ".$offset." ";
           // echo $sqlSelect;exit;
        }



        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getNewScholarshipList($countryId = false,$branch = false, $months = false, $year = false, $limit = false,$offset = false){

        $condition = $countryId?"shi.country_ref_id IN (".$countryId.")":"shi.country_ref_id IN (12,36,190,100,223,224,154)";

        if($months){
            $mcondition = " AND deadline_month IN($months)";
            $mcondition .= " AND deadline_year >= $year";
        }
        if($branch){
            $dcondition = "  AND sd.main_dept_ref_id IN(".$branch.")";
        }

        $sql = "SELECT sp.`scholarship_id`, sp.`scholarship_name`,GROUP_CONCAT(DISTINCT (tcm.country_name)) AS country_name, sp.scholarship_description, sp.amount, sp.frequency, lc.html_entity,GROUP_CONCAT(DISTINCT (shi.`country_ref_id`)) AS country_ref_id ,lst.type_name ,CAST(CONCAT_WS('-',deadline_year,deadline_month,deadline_day) AS DATE) AS dead_line FROM scholarship sp
                LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
                LEFT JOIN scholarship_department sd ON sd.scholarship_ref_id = shi.scholarship_ref_id
                LEFT JOIN lookup_currency AS lc ON sp.currency_ref_id = lc.currency_id
                LEFT JOIN `lookup_scholarship_type` lst ON lst.scholarship_type_id = sp.scholarship_type_ref_id
                LEFT JOIN `tbl_country_master` tcm ON tcm.country_id = shi.country_ref_id
                WHERE ".$condition."
                AND sp.is_active = 1
                AND sp.scholarship_provider_ref_id ='1'
                AND CAST(CONCAT_WS('-',deadline_year,deadline_month,deadline_day) AS DATE) >=  DATE(NOW())
                ".$dcondition.$mcondition."
                GROUP BY scholarship_id
                ORDER BY dead_line";
                if($limit){
                    $sql.= " LIMIT ".$limit." ";
                }
                if($offset){
                    $sql.= "OFFSET ".$offset." ";
                }
    $result = Yii::app()->db->createCommand($sql)->queryAll();
    return $result;
    }

    public static function getScholarshipCountries(){
        $sql = 'SELECT tcm.country_id,country_name FROM `scholarship` s
                LEFT JOIN `scholarship_host_institute` shi ON shi.scholarship_ref_id = s.scholarship_id
                LEFT JOIN tbl_country_master tcm ON tcm.country_id = s.country_ref_id
                WHERE tcm.is_active = "Y"
                GROUP BY tcm.country_id';
        $command = Yii::app()->db->createCommand($sql);
        $result = $command->queryAll();
        return CHtml::listData($result,'country_id','country_name');
    }

    public static function getAllScholarships(){
        $criteria = new CDbCriteria();
        $criteria->select = 'scholarship_id,url_primary_key, scholarship_name';
        $criteria->condition = "is_active = 1 AND url_primary_key != ''";
        $criteria->order = 'scholarship_name ASC';
        return $criteria;
    }

}