<?php

/**
 * This is the model class for table "chrysalis_tables".
 *
 * The followings are the available columns in table 'chrysalis_tables':
 * @property integer $chrysalis_table_id
 * @property string $table_name
 * @property string $class_name
 * @property string $table_type
 * @property string $is_active
 * @property string $added_on
 */
class ChrysalisTables extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ChrysalisTables the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'chrysalis_tables';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('table_name, class_name', 'length', 'max'=>100),
			array('table_type', 'length', 'max'=>7),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('chrysalis_table_id, table_name, class_name, table_type, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'chrysalis_table_id' => 'Chrysalis Table',
			'table_name' => 'Table Name',
			'class_name' => 'Class Name',
			'table_type' => 'Table Type',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('chrysalis_table_id',$this->chrysalis_table_id);
		$criteria->compare('table_name',$this->table_name,true);
		$criteria->compare('class_name',$this->class_name,true);
		$criteria->compare('table_type',$this->table_type,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}