<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseAdmin');

class Admin extends BaseAdmin
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    
    /**
	 * @return array relational rules.
	 */
	public function relations()
	{
	    return array(
	        'prospects' => array(self::HAS_MANY, 'Prospect', 'advisor_ref_id'),
	    	'abandonedProspects' => array(self::HAS_MANY, 'Prospect', 'reassigned_from'),
//	        'activeProspectCount' => array(self::STAT, 'Prospect', 'advisor_ref_id', 'condition' => "prospect_status = '" . Prospect::STATUS_IN_PROGRESS . "'"),
	        
	    );
	}
	
	/**
	 * Returns the associative list of admin names admin_ids
	 * @return array
	 */
	public static function getAssociativeList($excludeId = 0){
	    
        $criteria = new CDbCriteria();
        $criteria->order = "admin_name asc";
        $criteria->condition = "is_active = 'Y'";
        if($excludeId)    $criteria->compare('admin_id', $excludeId, false, '!=');
	    $records =  self::model()->findAll($criteria);
		
		$op = array();
		foreach($records as $record){
		    $op[$record->admin_id] = $record->admin_name;
		}
		return $op;
	}
	
	/**
	 * Returns the list of active advisors.
	 * @return array
	 */
	public static function getAdvisorAssociativeList(){
	    $criteria = new CDbCriteria();
        $criteria->order = "admin_name asc";
        $criteria->condition = "is_active = 'Y'";
        $criteria->compare('role_type_id', '13', false);
        $records =  self::model()->findAll($criteria);
		
		$op = array();
		foreach($records as $record){
		    $op[$record->admin_id] = $record->admin_name;
		}
		return $op;
	}
	
	public static function getAdvisorGridAssociativeList($notAssign = false){
	    try{
			$criteria = new CDbCriteria();
			$role_types=array(13,17);
			$criteria->order = "admin_name asc";
			$criteria->condition = "is_active = 'Y'";
		   // $criteria->compare('role_type_id', '13', false);
			$criteria->addInCondition('role_type_id', $role_types);
			$records =  self::model()->findAll($criteria);
			
			$op = array();
			foreach($records as $record){
				$op[$record->admin_id] = $record->admin_name;
			}
            if($notAssign == 'notAssigned'){
                $op['notAssigned'] = 'Not Assigned';
            }
			return $op;
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}

    public static function getSETAdvisorList($notAssign = false){
        try{
            $criteria = new CDbCriteria();
            $role_types=array(19);
            //$role_types=array(13,17,19);
            $criteria->order = "admin_name asc";
            $criteria->condition = "is_active = 'Y' ";
            //$criteria->condition = "is_active = 'Y' AND (team_member='SET' || team_member='SE') ";
            $criteria->addInCondition('role_type_id', $role_types);
            $records =  self::model()->findAll($criteria);

            $op = array();
            foreach($records as $record){
                $op[$record->admin_id] = $record->admin_name;
            }
            if($notAssign == 'notAssigned'){
                $op['notAssigned'] = 'Not Assigned';
            }
            return $op;
        }
        catch(Exception $ex)
        {
            echo $ex;
        }
    }

    public static function getAdminList($memberType='SET'){
        $criteria = new CDbCriteria();
        $role_types = array(13,17,14);
        $criteria->order = "admin_name asc";
        $criteria->condition = "is_active = 'Y' AND team_member='".$memberType."' ";
        $criteria->addInCondition('role_type_id', $role_types);
        $records =  self::model()->findAll($criteria);

        $op = array();
        foreach($records as $record){
            $op[$record->admin_id] = $record->admin_name;
        }
        return $op;
    }
	/**
	 * Returns the list of active external advisors.
	 * @return array
	 */
	public static function getExternalAdvisorAssociativeList(){
	    $criteria = new CDbCriteria();
        $criteria->order = "admin_name asc";
        $criteria->condition = "is_active = 'Y'";
        $criteria->compare('role_type_id', '17', false);
        $records =  self::model()->findAll($criteria);
		
		$op = array();
		foreach($records as $record){
		    $op[$record->admin_id] = $record->admin_name;
		}
		return $op;
	}

    public static function getAdminListByRole($roleId){
        $criteria = new CDbCriteria();
        $criteria->order = "admin_name asc";
        $criteria->condition = "is_active = 'Y' ";
        $criteria->addCondition("role_type_id = $roleId");
        $records =  self::model()->findAll($criteria);

        $op = array();
        foreach($records as $record){
            $op[$record->admin_id] = $record->admin_name;
        }
        return $op;
    }
	
	
	
}