<?php

class LoginController extends Controller {

        public $layout;
        public function init(){
            parent::init();
            Yii::app()->theme = 'uni_avada';
            $this->layout = "//layouts/registration";

        }

        public function actionIndex() {
            $this->canonicalUrl = 'https://www.univariety.com/app/login';
            Yii::app()->theme = 'new_grid_theme';
            $this->layout = "//layouts/new_grid_signup";
            $tmpRedirectUrl=base64_decode($_GET['ref']);
            //check if the user is already loggedin
            if(Yii::app()->session->get('loginID') && $tmpRedirectUrl == '') {              
				$this->redirect(Yii::app()->user->redirectUrl);			
            }
            if(Yii::app()->session->get('loginID')&& $tmpRedirectUrl)
            {
                $this->redirect($tmpRedirectUrl.'/yearEndForm/Colleges');
            }

            $next_url = '';
            if ($_GET['val']) {
                $email = base64_decode($_GET['val']);
                $login_master = LoginMaster::model()->findByAttributes(array('username'=>$email));
                if ($login_master) {
                    if ($login_master->is_email_confirmed == 0) {
                        $login_master->is_email_confirmed = 1;
                        $login_master->save(false);
                    }
                    $next_url = '/app/setPassword';
                }
            }
			
            /*
             * $sReturnUrl = Yii::app()->request->getQuery('requrl',0); 
            if($sReturnUrl)
                $this->redirect()
            */
            $redirectURL = Yii::app()->request->getParam('redirectURL',null);
            
            $time_start = microtime(true);

            $model = new LoginMaster();
            $time_end = microtime(true);
            $time = $time_end - $time_start;

            //$model_remember = new LoginMasterRemember();
            // if it is ajax validation request
            if(isset($_POST['ajax']) && $_POST['ajax']==='login-form') {
                    echo CActiveForm::validate($model);
                    Yii::app()->end();
            }
            
            // collect user input data
            if(isset($_POST['LoginMaster'])) {
                $model->attributes=$_POST['LoginMaster'];			
                // validate user input and redirect to the previous page if valid
                if($model->validate() && $model->login()) {
                    $pwd_det= LoginMaster::model()->findByAttributes(array('username'=>$model->username));
                   /* Yii::import('application.modules.ctp.models.*');
                    if(!empty($pwd_det)){                       
                        $ctp_info=  CtpInfo::model()->findByAttributes(array('login_ref_id'=>$pwd_det->login_id,'is_active'=>'Y')); 
                        if(!empty($ctp_info)){                            
                            $this->redirect ('ctp');
                        }
                    }*/
                    //Added to check whether password is auto generated or 
                    if(!empty($pwd_det) && $pwd_det->is_systempwd==1)
                    {
                            $new_login= LoginMaster::model()->findByPk($pwd_det->login_id);						
                            $new_login->is_systempwd=0;					
                            $new_login->save();
                            $next_url = '/app/setPassword';
                    }						
                    if ($next_url != '') {
                        $this->check_verification();
                        $this->redirect ($next_url);
                    }
                    if ($_COOKIE['url']) {
                            setcookie('url', '', time()-10, '/');
                            setcookie('url', null, time()-1000, "/", ".".ACTUALHOST);
                            $this->redirect($_COOKIE['url']);
                    } else {                           
                            if($redirectURL) $this->redirect ($redirectURL, true, 302);
                            $this->redirect(Yii::app()->user->redirectUrl);
                    }
					//Yii::app()->user->setReturnUrl();
                }
            }
            // display the login form
            $this->render('index',array('model'=>$model));
        }

        public function actionLogOut(){

            // clears facebook session
            //$fb = Yii::app()->facebook;
            //$fb->destroySession();
            Yii::app()->user->logout();
            $this->redirect(Yii::app()->user->loginUrl);
        }

        public function actionShowLoginPopUp(){
            if($_POST){
                Yii::app()->session->add('redirectURL', Yii::app()->request->getParam('redirectURL'));
                $frmErrors = array('hasErrors' => false);
                $model = new LoginMaster();
                if(isset($_POST['LoginMaster'])) {
                    $model->attributes=$_POST['LoginMaster'];
                    // validate user input and redirect to the previous page if valid
                    if($model->validate() && $model->login()) {
                        // Do nothing as JS will handle
                    }else{
                        if($model->hasErrors()){
                            $errorMsgs = array();
                            foreach ($model->getErrors() as $attribute=>$errors)
                                $errorMsgs[CHtml::activeId($model,$attribute)]=$errors;
                            $frmErrors = array('hasErrors' => true, 'errorMsgs' => $errorMsgs);
                        }
                    }
                }
                die(json_encode($frmErrors));
            }
            $this->renderPartial("/checkAdmissionScore/loginSignup");
        }
		
    public function actionLoginRedirect() {
        $values = base64_decode($_GET['ref']);
        $values_arr = explode('===', $values);

        $loginDet = LoginMaster::model()->find('login_id = '.$values_arr[0]);

        $loginObj = new LoginMaster;
        $loginObj->skipPassword = true;
        $loginObj->loginWithRedirect($loginDet->username,'', $values_arr[1]);
    }

    private function check_verification() {
        Yii::import('application.components.profilevalidation.*');
        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>Yii::app()->user->sub_id));
        if (!$profile_verify) {
            $obj = new ValidateStudent();
            $obj->userId=Yii::app()->user->sub_id;
            $obj->validateProfileAfterSignup();

            $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>Yii::app()->user->sub_id));
        }

        $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);

        $validate = new ValidateStudent();
        $validate->validate_after_confirmation($profile_verify->profile_verification_score_id, $user);
        return true;
    }

    public function actionConfirmEmail() {
        if (Yii::app()->user->id) {
            $login_obj = LoginMaster::model()->findByPk(Yii::app()->user->id);
            $login_obj->is_email_confirmed = 1;
            $login_obj->save();

            Yii::import('application.components.profilevalidation.*');
            $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>Yii::app()->user->sub_id));
            if (!$profile_verify) {
                $obj = new ValidateStudent();
                $obj->userId=Yii::app()->user->sub_id;
                $obj->validateProfileAfterSignup();

                $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>Yii::app()->user->sub_id));
            }

            $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);

            $validate = new ValidateStudent();
            $validate->validate_after_confirmation($profile_verify->profile_verification_score_id, $user);
        }

        $server = $_SERVER['SERVER_NAME'];
        $id = trim(Yii::app()->request->getQuery('id'));
        $type = trim(Yii::app()->request->getQuery('type'));

        if ($id) {
            $obj = ConfirmationEmailTracker::model()->findByPk($id);
            $obj->clicked = $type;
            $obj->clicked_on = date('Y-m-d H:i:s');
            $obj->save(false);
        }

        $url = '/app/dashboard';
        switch ($type) {
            case 1:
                setFlashMessage('success_notify', 'globalnotifications.emailConfirmation');
                break;
            case 2:
                $url = '/app/myProfile';
                break;
            case 3:
                $url = '/app/confirmation/shortList';
                break;
            case 4:
                $url = '/app/testsforyou/mytests';
                break;
            case 5:
                $url = '/app/dashboard';
                break;
        }

        Yii::app()->request->redirect('http://'.$server.$url);
    }

    public function actionPopupLogin()
    {
        $this->canonicalUrl = 'https://www.univariety.com/app/login';
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
        $tmpRedirectUrl=base64_decode(Yii::app()->request->getParam('ref'));
        //check if the user is already loggedin
        if(Yii::app()->session->get('loginID') && $tmpRedirectUrl == '') {
            $this->redirect(Yii::app()->user->redirectUrl);
        }
        if(Yii::app()->session->get('loginID')&& $tmpRedirectUrl)
        {
            $this->redirect($tmpRedirectUrl.'/yearEndForm/Colleges');
        }

        $next_url = '';
        if(Yii::app()->request->getParam('val')){
            $email = base64_decode(Yii::app()->request->getParam('val'));
            $login_master = LoginMaster::model()->findByAttributes(array('username'=>$email));
            if ($login_master) {
                if ($login_master->is_email_confirmed == 0) {
                    $login_master->is_email_confirmed = 1;
                    $login_master->save(false);
                }
                $next_url = '/app/setPassword';
            }
        }

        $redirectURL = Yii::app()->request->getParam('redirectURL',null);
        $model = new LoginMaster();

        if(Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest){
            $errors = json_decode(CActiveForm::validate($model));
            if(Yii::app()->request->getParam('career_plan_code') && !StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => Yii::app()->request->getParam('career_plan_code')))){
                
                $LoginMaster = Yii::app()->request->getParam('LoginMaster');
                
                $StudentCareerPlanCode = Yii::app()->db->createCommand()
                        ->select('StudentCareerPlanCode.student_career_plan_code_id')
                        ->from(StudentCareerPlanCode::model()->tableSchema->name.' StudentCareerPlanCode')
                        ->join(TblUserMaster::model()->tableSchema->name.' TblUserMaster', 'TblUserMaster.user_id = StudentCareerPlanCode.user_ref_id')
                        ->join(LoginMaster::model()->tableSchema->name.' LoginMaster', 'LoginMaster.login_id = TblUserMaster.login_ref_id AND LoginMaster.username = "'.$LoginMaster['username'].'"')
                        ->where('StudentCareerPlanCode.coupon_code = "'.Yii::app()->request->getParam('career_plan_code').'"')
                        ->queryRow();
                
                if(!$StudentCareerPlanCode){
                    if($errors){
                        $errors->career_plan_code = array('<div class="holder"><p>Invalid coupon code</p></div>');   
                    }else{
                        $errors['career_plan_code'] = array('<div class="holder"><p>Invalid coupon code</p></div>');
                    }
                }
            }
            echo json_encode($errors);
            Yii::app()->end();
        }

        // collect user input data
        if(Yii::app()->request->isPostRequest){
            $model->attributes = Yii::app()->request->getParam('LoginMaster');
            // validate user input and redirect to the previous page if valid
            if($model->validate() && $model->login()){
                $pwd_det = LoginMaster::model()->findByAttributes(array('username'=>$model->username));

                if(Yii::app()->request->getParam('career_plan_code')){
                    // find user institute by coupon code
                    $StudentCareerPlanCode = StudentCareerPlanCode::model()->find('coupon_code = :coupon_code AND user_ref_id IS NULL AND used_on IS NULL', array(':coupon_code' => Yii::app()->request->getParam('career_plan_code')));
                    if($StudentCareerPlanCode->inst_ref_id){
                        // if institue exists find his school
                        $school_id = Yii::app()->db->createCommand()
                                ->select('school_ref_id')
                                ->from(TblSiDi::model()->tableSchema->name)
                                ->where('inst_id = '.$StudentCareerPlanCode->inst_ref_id)
                                ->queryScalar();
                        
                        $UserMaster = TblUserMaster::model()->find('login_ref_id = '.$pwd_det->login_id);
                        // add user to school or change his school or remove his school based on $school_id
                        $UserMaster->school_ref_id = $school_id;
                        if($school_id){
                            $userMembershipRefId = $userMembershipRefId = Yii::app()->db->createCommand()
                                                ->select('membership_id')
                                                ->from('lookup_membership lm')
                                                ->where('membership_name=:name', array(':name' => 'SI Student'))
                                                ->queryRow();
                            $UserMaster->membership_ref_id = empty($userMembershipRefId['membership_id']) ? NULL : $userMembershipRefId['membership_id'];
                        }
                        $UserMaster->save(FALSE);
                        
                        $StudentCareerPlanCode->user_ref_id = $UserMaster->user_id;
                        $StudentCareerPlanCode->band_ref_id = Yii::app()->request->getParam('career_band_name');
                        $StudentCareerPlanCode->used_on = date('Y-m-d H:i:s');
                        $StudentCareerPlanCode->save(FALSE);
                        
                        //inserting or modifing to tbl_si_students
                        $SiStudent = TblSiStudents::model()->find('user_ref_id = '.$UserMaster->user_id);

                        if($SiStudent){
                            $SiStudent->inst_ref_id = $StudentCareerPlanCode->inst_ref_id;
                            $SiStudent->save(FALSE);
                        }else{
                            $SiStudent = new TblSiStudents;
                            $SiStudent->setAttributes(array(
                                'user_ref_id' => $UserMaster->user_id,
                                'inst_ref_id' => $StudentCareerPlanCode->inst_ref_id,
                                'is_invited' => 'N',
                                'is_invitation_accepted' => 'N',
                                'added_on' => date('Y-m-d H:i:s')
                            ), FALSE);
                            $SiStudent->save(FALSE);
                        }
                    }
                }
                
                //Added to check whether password is auto generated or
                if(!empty($pwd_det) && $pwd_det->is_systempwd==1){
                    $new_login= LoginMaster::model()->findByPk($pwd_det->login_id);
                    $new_login->is_systempwd=0;
                    $new_login->save();
                    $next_url = '/app/setPassword';
                }

                if($next_url != ''){
                    $this->check_verification();
                    $this->redirect ($next_url);
                }

                if($_COOKIE['url']) {
                    setcookie('url', '', time()-10, '/');
                    setcookie('url', null, time()-1000, "/", ".".ACTUALHOST);
                    exit("<script type='text/javascript'> window.parent.location = '".$_COOKIE['url']."';  </script>");
                    //$this->redirect($_COOKIE['url']);
                } else {
                    if($redirectURL) exit("<script type='text/javascript'> window.parent.location = '".$redirectURL."';  </script>");

                    exit("<script type='text/javascript'> window.parent.location = '".Yii::app()->user->redirectUrl."';  </script>");
                    //$this->redirect(Yii::app()->user->redirectUrl);
                }
                //Yii::app()->user->setReturnUrl();
            }
        }
        // display the login form

        //$this->render('popup_login',array('model'=>$model));
        
        $template = Yii::app()->request->getParam('carrer-plan') ? 'popup_login_plan' : 'popup_login';
        $this->renderPartial($template, array('model'=>$model),false, true);
    }
    
    public function actionGetUserBandInfo(){
        
        if(Yii::app()->request->isPostRequest){
            $username = Yii::app()->request->getParam('username', 0);
            
            $user = Yii::app()->db->createCommand()
                    ->select('LoginMaster.username, TblUserMaster.user_id, TblUserMaster.present_class')
                    ->from(LoginMaster::model()->tableSchema->name.' LoginMaster')
                    ->join(TblUserMaster::model()->tableSchema->name.' TblUserMaster', 'TblUserMaster.login_ref_id = LoginMaster.login_id')
                    ->where('LoginMaster.username = :username', array(':username' => $username))
                    ->queryRow();
            
            if($user){
                $band = Yii::app()->db->createCommand()
                        ->select('StudentCareerPlanCode.band_ref_id, StudentCareerPlanCode.coupon_code, LookupBand.band_name')
                        ->from(StudentCareerPlanCode::model()->tableSchema->name.' StudentCareerPlanCode')
                        ->join(LookupBand::model()->tableSchema->name.' LookupBand', 'StudentCareerPlanCode.band_ref_id = LookupBand.band_id')
                        ->where('user_ref_id = '.$user['user_id'])
                        ->queryRow();
                if($band){
                    $user['band_id'] = $band['band_ref_id'];
                    $user['coupon_code'] = $band['coupon_code'];
                    
                    switch ($band['band_name']) {
                        case 'Orange':
                            $user['band_name'] = 'career_band_orange';
                            break;
                        case 'Purple':
                            $user['band_name'] = 'career_band_purple';
                            break;
                        case 'Blue':
                            $user['band_name'] = 'career_band_blue';
                            break;
                        case 'Purple and Blue':
                            $user['band_name'] = 'career_band_purple_and_blue';
                            break;
                        case 'Green':
                            $user['band_name'] = 'career_band_green';
                            break;
                        default:
                            $user['band_name'] = false;
                            break;
                    }
                    
                    
                }
            }
        }
        
        echo json_encode(array_merge(array('user_id' => false, 'username' => false, 'present_class' => false, 'band_id' => false, 'band_name' => false, 'coupon_code' => false), empty($user) ? array():$user));
        Yii::app()->end();
    }
    
    
}