<?php

class StudentMarks extends CComponent {

    private $studentboardid;

    private $overall;

    public $subjects = array();

    private $standardtests = array();

    public function setStudentBoardId($studentboardid) {

        $this->studentboardid = $studentboardid;
    }

    public function getStudentBoardId() {

        return $this->studentboardid;
    }

    public function setOverAll($overall) {

        $this->overall = $overall;
    }

    public function getOverAll() {

        return $this->overall;
    }

    public function setSubject($oSubject){

        if(is_object($oSubject))
            $this->subjects[$oSubject->subjectName] = $oSubject;
    }

    public function getSubjects(){

        return $this->subjects;
    }

    public function getSubjectObject($subjectName){

        return isset($this->subjects[$subjectName]) ? $this->subjects[$subjectName] : false;
    }

    public function unsetSubjectObject($subjectName){

       if(isset($this->subjects[$subjectName])) {
            unset($this->subjects[$subjectName]);
        }
    }

    public function getMarksBySubject($subjectName){

        return isset($this->subjects[$subjectName]) ? $this->subjects[$subjectName]->subjectMarks : '';
    }

    public function setStandardTest($oTest){

        if(is_object($oTest))
            $this->standardtests[$oTest->standardTestName] = $oTest;
    }

    public function getStandardTests(){

        return $this->standardtests;
    }

    public function getStandardTestObject($testName){

        return isset($this->standardtests[$testName]) ? $this->standardtests[$testName] : false;
    }

    public function getSectionsByStandardTest($testName){

        return isset($this->standardtests[$testName]) ? $this->standardtests[$testName]->standardTestSections : false ;
    }

    public function unsetStandardTestObject($testName){

        if(isset($this->standardtests[$testName])) {
            unset($this->standardtests[$testName]);
        }
    }

    public function unsetSectionsByTest($testName, $sectionName = ''){

        if(isset($this->standardtests[$testName])) {
            if($sectionName)
                unset($this->standardtests[$testName]->standardTestSections[$sectionName]);
            else
                $this->standardtests[$testName]->standardTestSections = array();
        }
    }

    public function getStandardTestSectionObject($testName, $sectionName){

        return isset($this->standardtests[$testName]->standardTestSections[$sectionName]) ? $this->standardtests[$testName]->standardTestSections[$sectionName] : false ;
    }

}
